/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.component.service.UserAnonymizerService;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Path(value="/user-anonymizer")
@Produces(value={"application/json"})
public class UserAnonymizerRest {
    @ComponentImport
    private final UserAccessor userAccessor;
    private final UserManager userManager;
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    private final UserAnonymizerService userAnonymizerService;
    private final IGDPRUserManager gdprUserManager;
    @ComponentImport
    private final I18nResolver i18n;

    @Autowired
    public UserAnonymizerRest(UserAccessor userAccessor, @Qualifier(value="userManager") UserManager userManager, UserAnonymizerService userAnonymizerService, PluginAccessor pluginAccessor, IGDPRUserManager gdprUserManager, I18nResolver i18n) {
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.userAnonymizerService = userAnonymizerService;
        this.pluginAccessor = pluginAccessor;
        this.gdprUserManager = gdprUserManager;
        this.i18n = i18n;
    }

    @GET
    @Path(value="/check-user/{userName}")
    public Response checkUserForUpdateRights(@PathParam(value="userName") String userName) {
        try {
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            ConfluenceUser applicationUser = this.userAccessor.getUserByName(userName);
            if (applicationUser != null) {
                HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
                resultMap.put("canUpdateGroupMembershipForUser", true);
                resultMap.put("canUpdateUser", true);
                return Response.ok().entity((Object)new Gson().toJson(resultMap)).build();
            }
            return Response.noContent().build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/global-changes")
    public Response runGlobalChanges(@FormParam(value="config") String config) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map configMap = (Map)new Gson().fromJson(config, type);
        ConfluenceUser applicationUser = this.userAccessor.getUserByName((String)configMap.get("userName"));
        if (applicationUser != null) {
            if (!this.userManager.isAdmin(applicationUser.getKey()) && !this.userManager.isSystemAdmin(applicationUser.getKey())) {
                String result = this.userAnonymizerService.runGlobalChanges(configMap);
                return Response.ok().entity((Object)new Gson().toJson((Object)result)).build();
            }
            return Response.status((int)403).entity((Object)"User has admin or system admin rights and can not be modificated").build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/content-changes/check")
    public Response checkConfigForContentChanges(@FormParam(value="config") String config) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map configMap = (Map)new Gson().fromJson(config, type);
        return Response.ok().build();
    }

    @POST
    @Path(value="/content-changes")
    public Response runContentChanges(@FormParam(value="config") String config) {
        try {
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map configMap = (Map)new Gson().fromJson(config, type);
            String jobId = this.userAnonymizerService.runContentChanges(configMap);
            return Response.ok().entity((Object)new Gson().toJson((Object)jobId)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/content-changes/affected")
    public Response getAffectedContent(@FormParam(value="config") String config) {
        try {
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map configMap = (Map)new Gson().fromJson(config, type);
            Collection<ContentChangerResult> contentChangerResults = this.userAnonymizerService.getAffectedContent(configMap);
            return Response.ok().entity((Object)new Gson().toJson(contentChangerResults)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/content-changes/job/{jobId}")
    public Response getJobStatus(@PathParam(value="jobId") String jobId) {
        try {
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            String status = this.userAnonymizerService.getStatus(jobId);
            return Response.ok().entity((Object)new Gson().toJson((Object)status)).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/check-additional-addons")
    public Response getAdditionalAddons() {
        try {
            this.gdprUserManager.ifNotAdminAndNotInAllowedGroupThrowException(this.i18n.getText("java-forbidden-exception-message"));
            Boolean isDigitalSignatureEnabled = this.pluginAccessor.isPluginEnabled("com.baloise.confluence.digital-signature");
            return Response.ok().entity((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"digitalSignature", (Object)isDigitalSignatureEnabled))).build();
        }
        catch (GDPRException e) {
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

