/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.service.TroubleshootingService;
import de.actonic.confluence.gdpr.model.TroubleshootingModel;
import de.actonic.confluence.gdpr.model.troobleshooting.ExportModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Path(value="troubleshooting")
public class TroubleshootingRest {
    @ComponentImport
    private UserManager userManager;
    private TroubleshootingService troubleshootingService;

    @Autowired
    public TroubleshootingRest(@Qualifier(value="userManager") UserManager userManager, TroubleshootingService troubleshootingService) {
        this.userManager = userManager;
        this.troubleshootingService = troubleshootingService;
    }

    @GET
    @Path(value="/")
    public Response getAllTroubleshootingData() throws IOException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.userManager.isSystemAdmin(user.getKey()) || this.userManager.isAdmin(user.getKey())) {
            TroubleshootingModel data = this.troubleshootingService.getTroubleshootingData();
            String json = new Gson().toJson((Object)data);
            File file = File.createTempFile("actonic-troubleshooting", "json");
            FileWriter writer = new FileWriter(file);
            writer.write(json);
            writer.flush();
            writer.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)"attachment; filename=\"actonic-troubleshooting.json\"");
            return response.build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You don't have permissions to get this data").build();
    }

    @GET
    @Path(value="/export")
    public Response getExportData() throws IOException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.userManager.isSystemAdmin(user.getKey()) || this.userManager.isAdmin(user.getKey())) {
            ExportModel data = this.troubleshootingService.getExportData();
            String json = new Gson().toJson((Object)data);
            File file = File.createTempFile("actonic-configuration", "json");
            FileWriter writer = new FileWriter(file);
            writer.write(json);
            writer.flush();
            writer.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)"attachment; filename=\"actonic-configuration.json\"");
            return response.build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You don't have permissions to get this data").build();
    }

    @PUT
    @Path(value="/import")
    @Consumes(value={"application/json"})
    public Response uploadImportData(ExportModel exportModel) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.userManager.isSystemAdmin(user.getKey()) || this.userManager.isAdmin(user.getKey())) {
            this.troubleshootingService.uploadImportData(exportModel);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"You don't have permissions to get this data").build();
    }
}

