/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ChangeIndexer;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerHistoryModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerPostFunctionModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerPostFunctionNotificationTypeEnum;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerReplaceModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerResultStatusEnum;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleSearchType;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskTypeEnum;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTemplateModel;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.component.manager.CqlManager;
import de.actonic.confluence.gdpr.component.manager.EmailManager;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTaskEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerHistoryDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskManager;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerChangeService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerPostFunctionService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerResultService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerRuleService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTemplateService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.action.email.EmailTemplatesReplacement;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.AttachmentAuthorChanger;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.BodyContentChanger;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.CommentChanger;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.CreatorUpdaterChanger;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.DCCommentAuthorChanger;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.DCWatcherChanger;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.LikeChanger;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.TitleChanger;
import de.actonic.confluence.gdpr.current.datacleaner.event.DataCleaner3dPartyAddonsEvent;
import de.actonic.confluence.gdpr.current.datacleaner.event.DataCleanerSaveResultDataEvent;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerExecuteService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerExecuteService.class);
    @ComponentImport
    private final I18nResolver i18n;
    private static final int MAX_SEARCH_RESULTS = 100;
    private static final String ANONYMIZED_STRING = "<anonymized>";
    private final String CREATOR_STRING = "creator";
    private final String REPORTER_STRING = "reporter";
    private final String ASSIGNEE_STRING = "assignee";
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Gson gson = new Gson();
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressNotifications(true)).suppressAutowatch(true).suppressEvents(true)).updateLastModifier(false).build();
    private final EventPublisher eventPublisher;
    private final UserAccessor userAccessor;
    private final PageManager pageManager;
    private final ContentEntityObjectDao contentEntityObjectDao;
    private final ChangeIndexer changeIndexer;
    private final CommentManager commentManager;
    private final LabelManager labelManager;
    private TransactionTemplate transactionTemplate;
    private final DataCleanerTemplateService dataCleanerTemplateService;
    private final DataCleanerTaskDao dataCleanerTaskDao;
    private final DataCleanerRuleService dataCleanerRuleService;
    private final DataCleanerHistoryDao dataCleanerHistoryDao;
    private final DataCleanerPostFunctionService dataCleanerPostFunctionService;
    private final ConfigurationManager configurationManager;
    private final EmailManager emailManager;
    private final DataCleanerChangeService dataCleanerChangeService;
    private final DataCleanerTaskManager dataCleanerTaskManager;
    private final DataCleanerResultService dataCleanerResultService;
    private final CommentChanger commentChanger;
    private final DCCommentAuthorChanger DCCommentAuthorChanger;
    private final TitleChanger titleChanger;
    private final CreatorUpdaterChanger creatorUpdaterChanger;
    private final DCWatcherChanger DCWatcherChanger;
    private final BodyContentChanger bodyContentChanger;
    private final AttachmentAuthorChanger attachmentAuthorChanger;
    private final LikeChanger likeChanger;
    private final CqlManager cqlManager;
    private final NotificationManager notificationManager;
    private final List<EmailTemplatesReplacement> emailTemplatesReplacements;

    @Autowired
    public DataCleanerExecuteService(I18nResolver i18n, @ComponentImport EventPublisher eventPublisher, @ComponentImport UserAccessor userAccessor, @ComponentImport PageManager pageManager, @ComponentImport ContentEntityObjectDao contentEntityObjectDao, @ComponentImport ChangeIndexer changeIndexer, @ComponentImport CommentManager commentManager, LabelManager labelManager, @ComponentImport TransactionTemplate transactionTemplate, DataCleanerTemplateService dataCleanerTemplateService, DataCleanerTaskDao dataCleanerTaskDao, DataCleanerRuleService dataCleanerRuleService, DataCleanerHistoryDao dataCleanerHistoryDao, DataCleanerPostFunctionService dataCleanerPostFunctionService, ConfigurationManager configurationManager, EmailManager emailManager, DataCleanerChangeService dataCleanerChangeService, DataCleanerTaskManager dataCleanerTaskManager, DataCleanerResultService dataCleanerResultService, CommentChanger commentChanger, DCCommentAuthorChanger DCCommentAuthorChanger2, TitleChanger titleChanger, CreatorUpdaterChanger creatorUpdaterChanger, DCWatcherChanger DCWatcherChanger2, BodyContentChanger bodyContentChanger, AttachmentAuthorChanger attachmentAuthorChanger, LikeChanger likeChanger, CqlManager cqlManager, NotificationManager notificationManager, List<EmailTemplatesReplacement> emailTemplatesReplacements) {
        this.i18n = i18n;
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.contentEntityObjectDao = contentEntityObjectDao;
        this.changeIndexer = changeIndexer;
        this.commentManager = commentManager;
        this.labelManager = labelManager;
        this.dataCleanerTemplateService = dataCleanerTemplateService;
        this.dataCleanerTaskDao = dataCleanerTaskDao;
        this.dataCleanerRuleService = dataCleanerRuleService;
        this.dataCleanerHistoryDao = dataCleanerHistoryDao;
        this.dataCleanerPostFunctionService = dataCleanerPostFunctionService;
        this.configurationManager = configurationManager;
        this.emailManager = emailManager;
        this.dataCleanerChangeService = dataCleanerChangeService;
        this.dataCleanerTaskManager = dataCleanerTaskManager;
        this.dataCleanerResultService = dataCleanerResultService;
        this.titleChanger = titleChanger;
        this.bodyContentChanger = bodyContentChanger;
        this.creatorUpdaterChanger = creatorUpdaterChanger;
        this.commentChanger = commentChanger;
        this.transactionTemplate = transactionTemplate;
        this.DCCommentAuthorChanger = DCCommentAuthorChanger2;
        this.likeChanger = likeChanger;
        this.DCWatcherChanger = DCWatcherChanger2;
        this.attachmentAuthorChanger = attachmentAuthorChanger;
        this.cqlManager = cqlManager;
        this.notificationManager = notificationManager;
        this.emailTemplatesReplacements = emailTemplatesReplacements;
    }

    public Map<String, Changer> getChangers() {
        HashMap changerMap = Maps.newHashMap();
        changerMap.put("title", this.titleChanger);
        changerMap.put("body", this.bodyContentChanger);
        changerMap.put("author", this.creatorUpdaterChanger);
        changerMap.put("comment", this.commentChanger);
        changerMap.put("comment-author", this.DCCommentAuthorChanger);
        changerMap.put("like", this.likeChanger);
        changerMap.put("watcher", this.DCWatcherChanger);
        changerMap.put("attach-author", this.attachmentAuthorChanger);
        return changerMap;
    }

    private boolean shouldCheckVersion(String selectedObject) {
        return StringUtils.equalsIgnoreCase((CharSequence)selectedObject, (CharSequence)"title") || StringUtils.equalsIgnoreCase((CharSequence)selectedObject, (CharSequence)"body") || StringUtils.equalsIgnoreCase((CharSequence)selectedObject, (CharSequence)"author") || StringUtils.equalsIgnoreCase((CharSequence)selectedObject, (CharSequence)"watcher");
    }

    public void execute(int templateId) {
        try {
            long startTask = System.currentTimeMillis();
            this.dataCleanerTaskDao.start(templateId);
            this.dataCleanerTaskDao.updateTaskByTemplateId(templateId, 0, 1, "Getting data for task...");
            DataCleanerTemplateModel template = this.dataCleanerTemplateService.getTemplate(templateId);
            List<DataCleanerRuleModel> rules = this.dataCleanerRuleService.getEnabledRules(templateId);
            if (rules.isEmpty()) {
                this.dataCleanerTaskDao.failed(templateId, "Canceled because there are no defined rules");
                return;
            }
            DataCleanerTaskEntity currentTask = this.dataCleanerTaskDao.getCurrentInProgressTask();
            int taskId = currentTask.getID();
            int taskType = currentTask.getTaskType();
            log.info(String.format("Task: %s. %s Started: Template %s, %s by %s, started at %s", new Object[]{taskId, DataCleanerTaskTypeEnum.getValue(taskType), templateId, template.getName(), currentTask.getCreator(), currentTask.getStartDate().toString()}));
            ConfluenceUser serviceUser = this.userAccessor.getUserByKey(new UserKey(this.configurationManager.getRunTasksFromUser()));
            AuthenticatedUserThreadLocal.set((ConfluenceUser)serviceUser);
            if (serviceUser == null) {
                this.dataCleanerTaskDao.failed(templateId, "Canceled because there is no service user defined");
                return;
            }
            Map<String, Changer> changersMap = this.getChangers();
            ArrayList savingResultList = Lists.newArrayList();
            Integer publishedResultList = 0;
            this.dataCleanerChangeService.dropPatternCompileMap();
            int currentIssueCount = 0;
            int foundIssuesCount = 0;
            int failedIssueCount = 0;
            int updateIssueCount = 0;
            int totalIssuesToSearchCount = StringUtils.isBlank((CharSequence)template.getCqlType()) || StringUtils.equalsIgnoreCase((CharSequence)template.getCqlType(), (CharSequence)"cql") ? this.cqlManager.getIssuesCount(template.getCql()) : this.cqlManager.getIssueCountV2(template.getCql());
            log.debug(String.format("Task: %s. Template details: %s.", taskId, this.gson.toJson((Object)template)));
            log.debug(String.format("Task: %s. Task details: %s.", taskId, this.gson.toJson((Object)this.dataCleanerTaskManager.entityToModel(currentTask))));
            log.debug(String.format("Task: %s. Expected content count: %s.", taskId, totalIssuesToSearchCount));
            Integer executionEntriesCount = this.configurationManager.getExecutionEntriesCount();
            this.dataCleanerTaskDao.updateTaskByTemplateId(templateId, 0, totalIssuesToSearchCount, "Task started successfully.");
            long executionTimeStampForFlushStatusToDB = System.currentTimeMillis();
            long timer = System.currentTimeMillis();
            while (currentIssueCount < totalIssuesToSearchCount) {
                List<AbstractPage> ceos = StringUtils.isBlank((CharSequence)template.getCqlType()) || StringUtils.equalsIgnoreCase((CharSequence)template.getCqlType(), (CharSequence)"cql") ? this.cqlManager.getContentFromCql(template.getCql(), currentIssueCount, 100, true) : this.cqlManager.getContentFromCqlV2(template.getCql(), currentIssueCount, 100, true);
                for (AbstractPage ceo : ceos) {
                    try {
                        boolean changesFound = false;
                        ImmutableMap ceoMap = ImmutableMap.of((Object)"id", (Object)ceo.getIdAsString(), (Object)"title", (Object)ceo.getTitle(), (Object)"link", (Object)ceo.getUrlPath(), (Object)"version", (Object)("" + ceo.getVersion()));
                        AbstractPage tempPage = (AbstractPage)this.pageManager.getById(ceo.getLatestVersionId());
                        ImmutableMap spaceMap = ImmutableMap.of((Object)"key", (Object)tempPage.getSpace().getKey(), (Object)"name", (Object)tempPage.getSpace().getName());
                        ContentEntityObject changedCeo = this.pageManager.getById(ceo.getId());
                        if (this.isTimerFinished(executionTimeStampForFlushStatusToDB, 1000)) {
                            this.dataCleanerTaskDao.updateTaskById(taskId, currentIssueCount, totalIssuesToSearchCount, "Processing [" + tempPage.getSpace().getName() + ":" + tempPage.getTitle() + " (" + ceo.getId() + ")] content...");
                            executionTimeStampForFlushStatusToDB = System.currentTimeMillis();
                        }
                        HashSet<Integer> proccessedRuleIds = new HashSet<Integer>();
                        for (String selectedObject : template.getObjects()) {
                            if (!this.dataCleanerTaskDao.hasTaskForTemplate(templateId)) {
                                return;
                            }
                            if (!changersMap.containsKey(selectedObject) || !this.shouldCheckVersion(selectedObject) && ceo.getId() != ceo.getLatestVersionId()) continue;
                            Changer changer = changersMap.get(selectedObject);
                            List<String> objectValues = changer.extractValues(ceo.getId());
                            for (String objectValue : objectValues) {
                                Optional<DataCleanerReplaceModel> replaceResult = this.dataCleanerChangeService.changeFieldByRules(objectValue, selectedObject, rules);
                                if (!replaceResult.isPresent()) continue;
                                List ruleNames = this.dataCleanerRuleService.getRules(new ArrayList<Integer>(replaceResult.get().getData().keySet())).stream().map(DataCleanerRuleModel::getName).collect(Collectors.toList());
                                log.trace(String.format("Task: %s. Issue %s.  Rules to be applied %s for fields %s.", taskId, ceo.getTitle(), this.gson.toJson(ruleNames), selectedObject));
                                HashSet anonymizedHistoryIds = Sets.newHashSet();
                                changesFound = true;
                                DataCleanerReplaceModel dataCleanerReplaceModel = replaceResult.get();
                                proccessedRuleIds.addAll(dataCleanerReplaceModel.getData().keySet());
                                for (Integer ruleId : dataCleanerReplaceModel.getData().keySet()) {
                                    if (taskType == DataCleanerTaskTypeEnum.SEARCH.getType()) {
                                        savingResultList.add(DataCleanerHistoryModel.builder().jobId(taskId).ceo((Map<String, String>)ceoMap).space((Map<String, String>)spaceMap).object(selectedObject).ruleId(ruleId).data(dataCleanerReplaceModel.getData().get(ruleId)).status(DataCleanerResultStatusEnum.FOUND.getCode()).ceoCreationDate(new Timestamp(changedCeo.getCreationDate().getTime())).build());
                                        continue;
                                    }
                                    if (taskType != DataCleanerTaskTypeEnum.ANONYMIZE.getType()) continue;
                                    savingResultList.add(DataCleanerHistoryModel.builder().jobId(taskId).ceo((Map<String, String>)ceoMap).space((Map<String, String>)spaceMap).object(selectedObject).ruleId(ruleId).data(ANONYMIZED_STRING).status(DataCleanerResultStatusEnum.ANONYMIZED.getCode()).ceoCreationDate(new Timestamp(changedCeo.getCreationDate().getTime())).build());
                                    anonymizedHistoryIds.add(savingResultList.size() - 1);
                                }
                                if (taskType != DataCleanerTaskTypeEnum.ANONYMIZE.getType()) continue;
                                try {
                                    changer.applyNewValues(ceo.getId(), (Map<String, String>)ImmutableMap.of((Object)objectValue, (Object)dataCleanerReplaceModel.getResultString()));
                                    ++updateIssueCount;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    for (Integer anonymizedHistoryId : anonymizedHistoryIds) {
                                        DataCleanerHistoryModel anonymizedModel = (DataCleanerHistoryModel)savingResultList.get(anonymizedHistoryId);
                                        anonymizedModel.setData(e.getMessage());
                                        anonymizedModel.setStatus(DataCleanerResultStatusEnum.FAILED.getCode());
                                        savingResultList.set(anonymizedHistoryId, anonymizedModel);
                                        log.trace(String.format("Task: %s. Issue %s Thrown an exception for field: %s, while to set new value: %s", taskId, ceo.getTitle(), selectedObject, e.getMessage()));
                                        ++updateIssueCount;
                                    }
                                }
                            }
                        }
                        if (taskType == DataCleanerTaskTypeEnum.ANONYMIZE.getType()) {
                            if (changesFound) {
                                log.trace(String.format("Task: %s. Issue %s Updated successfully.", taskId, ceo.getTitle()));
                                if (changedCeo != null && changedCeo.getId() == changedCeo.getLatestVersionId()) {
                                    this.changeIndexer.reIndexAllVersions((Searchable)changedCeo);
                                    this.printIssuedPostFunction(templateId, proccessedRuleIds, changedCeo.getId(), serviceUser);
                                }
                            } else {
                                log.trace(String.format("Task: %s. Issue %s No changes applied.", taskId, ceo.getTitle()));
                            }
                        }
                        if (changesFound) {
                            ++foundIssuesCount;
                        }
                    }
                    catch (Exception e) {
                        log.trace(String.format("Task: %s. Issue %s Thrown an exception: %s", taskId, ceo.getTitle(), e.getMessage()));
                        e.printStackTrace();
                    }
                    if (ceo.getId() == ceo.getLatestVersionId()) {
                        ++currentIssueCount;
                    }
                    if (!this.isTimerFinished(timer, 1000) && currentIssueCount < totalIssuesToSearchCount) continue;
                    this.eventPublisher.publish((Object)new DataCleanerSaveResultDataEvent(savingResultList));
                    publishedResultList = publishedResultList + savingResultList.size();
                    if (!this.dataCleanerTaskDao.hasTaskForTemplate(templateId)) {
                        return;
                    }
                    if (publishedResultList >= executionEntriesCount) {
                        this.dataCleanerTaskDao.setFoundObjectsCount(taskId, publishedResultList);
                        this.fixCountByLimits(templateId);
                        this.dataCleanerTaskDao.cancel(templateId, "Canceled by entities limit per execution " + executionEntriesCount + ". Please check app settings.");
                        return;
                    }
                    savingResultList = Lists.newArrayList();
                    timer = System.currentTimeMillis();
                }
            }
            if (taskType == DataCleanerTaskTypeEnum.ANONYMIZE.getType()) {
                this.throwEventsFor3dPartyAddons("Anonymization", taskId, template);
            } else {
                this.throwEventsFor3dPartyAddons("Search", taskId, template);
            }
            this.fixCountByLimits(templateId);
            this.dataCleanerTaskDao.setFoundObjectsCount(taskId, this.dataCleanerHistoryDao.getHistoryEntitiesCountByJobId(taskId));
            this.dataCleanerTaskDao.finish(templateId, this.i18n.getText("soy-data-cleaner-excecution-service.rest.finish"));
            this.printTotalPostFunction(this.dataCleanerTaskDao.getById(taskId), currentIssueCount, foundIssuesCount);
            long endTask = System.currentTimeMillis();
            long duration = (endTask - startTask) / 1000L;
            log.info(String.format("Task: %s. %s Finished: Template %s, %s by %s, started at %s, finished at %s, duration %s. Results: total %s issues, found %s affected objects, updated %s affected issues, failed to update %s issues.", taskId, DataCleanerTaskTypeEnum.getValue(taskType).toString(), templateId, template.getName(), currentTask.getCreator(), currentTask.getStartDate(), this.formatter.format(new Date()), duration, totalIssuesToSearchCount, foundIssuesCount, updateIssueCount, failedIssueCount));
        }
        catch (Exception e) {
            this.dataCleanerTaskDao.failed(templateId, "Task failed because of " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void throwEventsFor3dPartyAddons(String type, Integer taskId, DataCleanerTemplateModel template) {
        Integer templateId = template.getId();
        String scope = template.getCql();
        List<DataCleanerRuleModel> enabledRules = this.dataCleanerRuleService.getEnabledRules(templateId);
        HashMap<String, HashSet> storageUserAnonymizationData = new HashMap<String, HashSet>();
        HashSet<String> storageAnyUserAnonymizationData = new HashSet<String>();
        ArrayList storageContentAnonymizationData = Lists.newArrayList();
        block5: for (DataCleanerRuleModel rule : enabledRules) {
            switch (DataCleanerRuleSearchType.getValue(rule.getSearchType())) {
                case USER: {
                    HashSet sourceUsers;
                    String source = rule.getSearchString();
                    String target = rule.getReplaceString();
                    if (storageUserAnonymizationData.containsKey(target)) {
                        sourceUsers = (HashSet)storageUserAnonymizationData.get(target);
                        sourceUsers.add(source);
                        storageUserAnonymizationData.replace(target, sourceUsers);
                        continue block5;
                    }
                    sourceUsers = new HashSet();
                    sourceUsers.add(source);
                    storageUserAnonymizationData.put(target, sourceUsers);
                    continue block5;
                }
                case ANY_USER: {
                    storageAnyUserAnonymizationData.add(rule.getReplaceString());
                    continue block5;
                }
                case PLAIN: 
                case REGEX: {
                    storageContentAnonymizationData.add(rule);
                    continue block5;
                }
            }
            log.warn("Rule type [" + rule.getSearchType() + "] is incorrect, please check rules for template '" + template.getName() + "'");
        }
        for (String key : storageUserAnonymizationData.keySet()) {
            String sources = StringUtils.join((Iterable)((Iterable)storageUserAnonymizationData.get(key)), (String)",");
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("emitter", "User" + type + "Event");
            payload.put("scope", scope);
            payload.put("sourceUsers", sources);
            payload.put("targetUser", key);
            String hash = DigestUtils.sha1Hex((String)((Object)payload).toString());
            payload.put("taskId", taskId);
            this.eventPublisher.publish((Object)new DataCleaner3dPartyAddonsEvent(payload));
        }
        for (String value : storageAnyUserAnonymizationData) {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("emitter", "AnyUser" + type + "Event");
            payload.put("scope", scope);
            payload.put("targetUser", value);
            String hash = DigestUtils.sha1Hex((String)((Object)payload).toString());
            payload.put("taskId", taskId);
            this.eventPublisher.publish((Object)new DataCleaner3dPartyAddonsEvent(payload));
        }
        if (!storageContentAnonymizationData.isEmpty()) {
            HashMap<String, Object> payload = new HashMap<String, Object>();
            payload.put("emitter", "Content" + type + "Event");
            payload.put("scope", scope);
            payload.put("rules", new Gson().toJson((Object)storageContentAnonymizationData));
            String hash = DigestUtils.sha1Hex((String)((Object)payload).toString());
            payload.put("taskId", taskId);
            this.eventPublisher.publish((Object)new DataCleaner3dPartyAddonsEvent(payload));
        }
    }

    public void fixCountByLimits(int templateId) {
        if (this.dataCleanerTaskDao.getTasksCountForTemplate(templateId) >= this.configurationManager.getExecutionHistoryCount()) {
            List<DataCleanerTaskEntity> allTasksForRemoving = this.dataCleanerTaskDao.getAllTasksForRemoving(templateId);
            int difference = allTasksForRemoving.size() - this.configurationManager.getExecutionHistoryCount();
            for (int i = 0; i < difference; ++i) {
                this.dataCleanerHistoryDao.deleteAllEntitiesByTaskId(allTasksForRemoving.get(i).getID());
                this.dataCleanerTaskDao.delete(allTasksForRemoving.get(i).getID());
            }
        }
    }

    public List<DataCleanerHistoryModel> checkRulesAndTicketMatches(int templateId, Long ceoId) {
        try {
            DataCleanerTemplateModel template = this.dataCleanerTemplateService.getTemplate(templateId);
            List<DataCleanerRuleModel> rules = this.dataCleanerRuleService.getEnabledRules(templateId);
            Map<String, Changer> changersMap = this.getChangers();
            ArrayList savingResultList = Lists.newArrayList();
            this.dataCleanerChangeService.dropPatternCompileMap();
            AbstractPage ceo = (AbstractPage)this.pageManager.getById(ceoId.longValue());
            ImmutableMap pageMap = ImmutableMap.of((Object)"id", (Object)ceo.getIdAsString(), (Object)"title", (Object)ceo.getTitle(), (Object)"link", (Object)ceo.getUrlPath());
            ImmutableMap spaceMap = ImmutableMap.of((Object)"key", (Object)ceo.getSpace().getKey(), (Object)"name", (Object)ceo.getSpace().getName());
            HashSet<Integer> proccessedRuleIds = new HashSet<Integer>();
            for (String selectedObject : template.getObjects()) {
                if (!changersMap.containsKey(selectedObject)) continue;
                Changer changer = changersMap.get(selectedObject);
                List<String> objectValues = changer.extractValues(ceoId);
                for (String objectValue : objectValues) {
                    Optional<DataCleanerReplaceModel> replaceResult = this.dataCleanerChangeService.changeFieldByRules(objectValue, selectedObject, rules);
                    if (!replaceResult.isPresent()) continue;
                    DataCleanerReplaceModel dataCleanerReplaceModel = replaceResult.get();
                    proccessedRuleIds.addAll(dataCleanerReplaceModel.getData().keySet());
                    for (Integer ruleId : dataCleanerReplaceModel.getData().keySet()) {
                        savingResultList.add(DataCleanerHistoryModel.builder().ceo((Map<String, String>)pageMap).space((Map<String, String>)spaceMap).object(selectedObject).ruleId(ruleId).data(dataCleanerReplaceModel.getData().get(ruleId)).status(DataCleanerResultStatusEnum.FOUND.getCode()).build());
                    }
                }
            }
            return savingResultList;
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public List<DataCleanerHistoryModel> executeCustomAnonymization(int historyModelId) throws Exception {
        ConfluenceUser serviceUser = this.userAccessor.getUserByKey(new UserKey(this.configurationManager.getRunTasksFromUser()));
        if (serviceUser == null) {
            throw new Exception("Canceled because there is no service user defined");
        }
        DataCleanerHistoryModel dataCleanerHistoryModel = this.dataCleanerResultService.getHistoryModelById(historyModelId);
        DataCleanerRuleModel dataCleanerRuleModel = this.dataCleanerRuleService.getRule(dataCleanerHistoryModel.getRuleId());
        ContentEntityObject ceo = this.pageManager.getById(Long.parseLong(dataCleanerHistoryModel.getCeo().get("id")));
        Map<String, Changer> changersMap = this.getChangers();
        if (changersMap.containsKey(dataCleanerHistoryModel.getObject())) {
            Changer changer = changersMap.get(dataCleanerHistoryModel.getObject());
            List<String> objectValues = changer.extractValues(ceo.getId());
            for (String objectValue : objectValues) {
                Optional<DataCleanerReplaceModel> replaceResult;
                if (!StringUtils.containsIgnoreCase((CharSequence)dataCleanerHistoryModel.getData(), (CharSequence)objectValue) || !(replaceResult = this.dataCleanerChangeService.changeFieldByRules(objectValue, dataCleanerHistoryModel.getObject(), Lists.newArrayList((Object[])new DataCleanerRuleModel[]{dataCleanerRuleModel}))).isPresent()) continue;
                DataCleanerReplaceModel dataCleanerReplaceModel = replaceResult.get();
                changer.applyNewValues(ceo.getId(), (Map<String, String>)ImmutableMap.of((Object)objectValue, (Object)dataCleanerReplaceModel.getResultString()));
                this.contentEntityObjectDao.saveRaw((EntityObject)ceo);
                this.changeIndexer.reIndexAllVersions((Searchable)ceo);
                dataCleanerHistoryModel.setData(ANONYMIZED_STRING);
                dataCleanerHistoryModel.setStatus(DataCleanerResultStatusEnum.ANONYMIZED.getCode());
                this.dataCleanerResultService.updateHistoryModel(dataCleanerHistoryModel);
                return Lists.newArrayList((Object[])new DataCleanerHistoryModel[]{dataCleanerHistoryModel});
            }
        }
        throw new Exception("Nothing to do");
    }

    private boolean checkObjectUser(String value) {
        return "creator".equals(value) || "reporter".equals(value) || "assignee".equals(value);
    }

    private boolean isTimerFinished(Long startTime, Integer stopPeriodInMilliseconds) {
        Long currentTime = System.currentTimeMillis();
        return currentTime - startTime > (long)stopPeriodInMilliseconds.intValue();
    }

    private void printIssuedPostFunction(int templateId, Set<Integer> processedRuleIds, Long ceoId, ConfluenceUser serviceUser) {
        List<DataCleanerPostFunctionModel> postFunctions = this.dataCleanerPostFunctionService.getAllPostFunctions(templateId);
        block0: for (DataCleanerPostFunctionModel postFunction : postFunctions) {
            if (!postFunction.isEnabled()) continue;
            if (postFunction.isAnyRuleEnabled()) {
                this.sendPostFunctionNotification(postFunction, ceoId, serviceUser);
                log.info("COMMENT SHOULD BE ADDED FOR ISSUE = " + ceoId + " (any rule enabled)");
                continue;
            }
            for (String ruleIdAsString : postFunction.getRules().split(",")) {
                if (!processedRuleIds.contains(Integer.parseInt(ruleIdAsString))) continue;
                this.sendPostFunctionNotification(postFunction, ceoId, serviceUser);
                log.info("COMMENT SHOULD BE ADDED FOR ISSUE = " + ceoId + " (rule = " + ruleIdAsString + ")");
                continue block0;
            }
        }
    }

    private void printTotalPostFunction(DataCleanerTaskEntity task, int totalIssues, int foundIssues) {
        String messageTemplate = "\"%s\" task for \"%s\" finished.\nFound %s entities in %s uniq entities. Processed %s entities.\nTask finished at %s. It takes %s minutes.";
        String taskType = "Undefined";
        if (task.getTaskType() == DataCleanerTaskTypeEnum.SEARCH.getType()) {
            taskType = "Search";
        } else if (task.getTaskType() == DataCleanerTaskTypeEnum.ANONYMIZE.getType()) {
            taskType = "Anonymization";
        }
        DataCleanerTemplateModel template = this.dataCleanerTemplateService.getTemplate(task.getTemplateId());
        int historyEntities = this.dataCleanerHistoryDao.getHistoryEntitiesByJobId(task.getID()).size();
        int diffMinutes = -1;
        try {
            long diff = task.getEndDate().getTime() - task.getStartDate().getTime();
            diffMinutes = (int)(diff / 1000L / 60L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String message = String.format(messageTemplate, taskType, template.getName(), historyEntities, foundIssues, totalIssues, task.getEndDate(), diffMinutes);
        if (template.getNotificationType() != null) {
            if (template.getNotificationType().equalsIgnoreCase("logging")) {
                log.error(message);
            } else if (template.getNotificationType().equalsIgnoreCase("email")) {
                for (String email : template.getNotificationParameters().get("emails").split(",")) {
                    this.emailManager.sendMessage("\"" + taskType + "\" task finished", message, email);
                }
            }
        }
    }

    private void sendPostFunctionNotification(DataCleanerPostFunctionModel postFunction, Long pageId, ConfluenceUser serviceUser) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(pageId.longValue());
            if (ceo == null || ceo.getId() != ceo.getLatestVersionId()) {
                return false;
            }
            if (DataCleanerPostFunctionNotificationTypeEnum.COMMENT.getType().equals(postFunction.getNotificationType())) {
                this.commentManager.addCommentToObject(ceo, null, postFunction.getNotificationParameters().get("comment"));
            }
            if (DataCleanerPostFunctionNotificationTypeEnum.LABEL.getType().equals(postFunction.getNotificationType())) {
                Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
                List labels = splitter.splitToList((CharSequence)postFunction.getNotificationParameters().get("label"));
                for (String label : labels) {
                    Label lbl = new Label(label);
                    this.labelManager.addLabel((Labelable)ceo, lbl);
                }
            }
            if (DataCleanerPostFunctionNotificationTypeEnum.EMAIL.getType().equals(postFunction.getNotificationType())) {
                for (String recipient : this.getEmailAddressByRecipient(ceo, postFunction.getNotificationParameters().get("recipient"))) {
                    String message = postFunction.getNotificationParameters().get("message");
                    String resultMessage = this.replaceEmailTemplatesVariables(message, ceo);
                    this.emailManager.sendMessage(postFunction.getNotificationParameters().get("subject"), resultMessage, recipient);
                }
            }
            return true;
        });
    }

    private String replaceEmailTemplatesVariables(String message, ContentEntityObject ceo) {
        AbstractPage abstractPage = (AbstractPage)ceo;
        for (EmailTemplatesReplacement replacement : this.emailTemplatesReplacements) {
            if (!replacement.isValid(message)) continue;
            message = replacement.doAction(message, abstractPage);
        }
        return message;
    }

    private Set<String> getEmailAddressByRecipient(ContentEntityObject ceo, String recipientName) {
        HashSet recipients = Sets.newHashSet();
        if ("assignee".equals(recipientName) && ceo.getLastModifier() != null && !Strings.isNullOrEmpty((String)ceo.getLastModifier().getEmail())) {
            recipients.add(ceo.getLastModifier().getEmail());
        }
        if ("watchers".equals(recipientName)) {
            List notifications = this.notificationManager.getNotificationsByContent(ceo);
            for (Notification notification : notifications) {
                if (notification.getReceiver() == null || Strings.isNullOrEmpty((String)notification.getReceiver().getEmail())) continue;
                recipients.add(notification.getReceiver().getEmail());
            }
        }
        return recipients;
    }

    public DataCleanerTaskModel status() {
        return this.dataCleanerTaskManager.entityToModel(this.dataCleanerTaskDao.getCurrentInProgressTask());
    }

    private int getPercent(int current, int size) {
        return current * 100 / size;
    }

    private String convertMapToString(Map<String, String> data) {
        return new Gson().toJson(data);
    }
}

