define("actonic-gdpr/access-statistics/intro", ["jquery", "actonic-gdpr/core/intro-rest"], function ($, CoreIntroRest) {

    var Intro = {
        init: function () {
            var username = AJS.Meta.get("remote-user");
            if (username) {
                CoreIntroRest.isIntroShowed("access", username,
                    function (data) { // success
                        //log.debug(data);
                        if (!data) {
                            Intro.showIntro();
                        }
                    },
                    function (data) { // error
                        log.error("intro.cannot.load.connection.error " + data.responseText);
                    });
            } else {
                log.error("intro.cannot.load.user.not.found");
            }
        },
        showIntro: function() {
            if (introJs) {
                Intro.setIntroSteps();

                var tour = introJs();
                tour.setOption('tooltipPosition', 'auto');
                tour.setOption('positionPrecedence', ['left', 'right', 'bottom', 'top']);
                tour.start();
            } else {
                log.error("intro.cannot.load.introjs.not.found");
            }
        },
        setIntroSteps: function () {
            $("#filter-form-container").parent().attr("data-step", "1").attr("data-intro", AJS.I18n.getText("js-access-intro.intro.step-1"));
            $("#sort-by-picker").parent().attr("data-step", "2").attr("data-intro", AJS.I18n.getText("js-access-intro.intro.step-2"));
            $("#filter-button").parent().attr("data-step", "3").attr("data-intro", AJS.I18n.getText("js-access-intro.intro.step-3"));
        }
    }

    return Intro;
});
