/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.general.servlet;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class AnnouncementsDashboardServlet
extends HttpServlet {
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    private final IGDPRUserManager userManager;

    public AnnouncementsDashboardServlet(PluginAccessor pluginAccessor, IGDPRUserManager userManager) {
        this.pluginAccessor = pluginAccessor;
        this.userManager = userManager;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String contextPath = req.getContextPath();
            if (this.userManager.getLoggedUser() == null) {
                resp.sendRedirect(contextPath + "/login.action?os_destination=%2Fplugins%2Fservlet%2Factonic-gdpr%2Fannouncer%23%2Fannouncer%2Fdashboard&permissionViolation=true");
            } else if (!this.userManager.isAdmin()) {
                resp.sendRedirect(contextPath + "/login.action?os_destination=%2Fadmin%2Fplugins%2Fservlet%2Factonic-gdpr%2Fannouncer");
            }
            Map data = MacroUtils.defaultVelocityContext();
            data.put("contextPath", req.getContextPath());
            Date installedDate = this.pluginAccessor.getEnabledPlugin("de.actonic.confluence.dgpr-tools").getDateInstalled();
            data.put("installedDate", installedDate.getTime());
            String content = VelocityUtils.getRenderedTemplate((String)"/actonic-gdpr-resources/announcements/announcements-new.vm", (Map)data);
            resp.setContentType("text/html;charset=utf-8");
            resp.getWriter().write(content);
            resp.getWriter().close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String stacktrace = ExceptionUtils.getStackTrace((Throwable)e);
            try {
                resp.sendError(500, stacktrace);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                resp.setStatus(500);
            }
        }
    }
}

