/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.Like;
import com.atlassian.confluence.like.LikeManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import de.actonic.gdpr.datacleaner.service.changer.DCConfluenceFieldChanger;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCFieldChangerValue;
import de.actonic.gdpr.shared.datacleaner.model.fieldchanger.DCIFieldChangerValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class DCLikeChanger
extends DCConfluenceFieldChanger {
    @ComponentImport
    private final LikeManager likeManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;

    public DCLikeChanger(LikeManager likeManager, UserAccessor userAccessor, TransactionTemplate transactionTemplate, @ComponentImport PageManager pageManager) {
        super(pageManager);
        this.likeManager = likeManager;
        this.userAccessor = userAccessor;
        this.transactionTemplate = transactionTemplate;
    }

    public String getType() {
        return "user";
    }

    public List<DCIFieldChangerValue> extractValues(Long contentObjectId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            ArrayList resultList = Lists.newArrayList();
            List likes = this.likeManager.getLikes(ceo);
            for (Like like : likes) {
                ConfluenceUser confluenceUser = this.userAccessor.getUserByName(like.getUsername());
                if (confluenceUser == null || !resultList.stream().noneMatch(fcv -> fcv.getValue().equals(confluenceUser.getKey().toString()))) continue;
                resultList.add(new DCFieldChangerValue(confluenceUser.getKey().toString()));
            }
            return resultList;
        });
    }

    public void applyNewValues(Long contentObjectId, Map<DCIFieldChangerValue, String> oldNewValueMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.getPageById(contentObjectId);
            List likes = this.likeManager.getLikes(ceo);
            for (Like like : likes) {
                ConfluenceUser target = this.userAccessor.getUserByName(like.getUsername());
                if (target == null) continue;
                for (Map.Entry entry : oldNewValueMap.entrySet()) {
                    if (!target.getKey().toString().equals(((DCIFieldChangerValue)entry.getKey()).getValue())) continue;
                    this.likeManager.removeLike(ceo, (User)target);
                    ConfluenceUser source = this.userAccessor.getUserByName((String)entry.getValue());
                    this.likeManager.addLike(ceo, (User)source);
                }
            }
            return true;
        });
    }
}

