/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.gdpr.datacleaner.ao.DCIgnoreEntity;
import de.actonic.gdpr.shared.datacleaner.model.DCIgnoreModel;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DCIgnoreDao
extends AbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(DCIgnoreDao.class);

    @Autowired
    public DCIgnoreDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public DCIgnoreEntity createEntity(Long templateId, String type, String value, String description) {
        DCIgnoreEntity entity = (DCIgnoreEntity)this.ao.create(DCIgnoreEntity.class, new DBParam[0]);
        entity.setTemplateId(templateId);
        entity.setType(type);
        entity.setValue(value);
        entity.setDescription(description);
        entity.save();
        return entity;
    }

    public List<DCIgnoreEntity> getAllEntities() {
        Object[] entities = (DCIgnoreEntity[])this.ao.find(DCIgnoreEntity.class, Query.select().order("ID ASC"));
        return Lists.newArrayList((Object[])entities);
    }

    public DCIgnoreEntity updateEntity(int id, Long templateId, String type, String value, String description) {
        DCIgnoreEntity entity = this.getFirstByField(DCIgnoreEntity.class, "ID", id);
        entity.setTemplateId(templateId);
        entity.setType(type);
        entity.setValue(value);
        entity.setDescription(description);
        entity.save();
        return entity;
    }

    public void deleteEntity(int id) {
        DCIgnoreEntity entity = this.getFirstByField(DCIgnoreEntity.class, "ID", id);
        this.ao.delete(new RawEntity[]{entity});
    }

    public void importEntities(List<DCIgnoreModel> models) {
        models.forEach(model -> this.createEntity(model.getTemplateId(), model.getType(), model.getValue(), model.getDescription()));
    }
}

