/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.upgrade.v3;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask003
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask003.class);
    private final PluginSettings pluginSettings;

    public UpgradeTask003(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr.component.service.UserAnonymizerService");
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"3");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        try {
            log.debug("Starting upgrade job...");
            Object data = this.pluginSettings.get("");
            if (data != null) {
                log.debug("Has empty pluginSettings key = '" + data.toString() + "'");
            } else {
                log.debug("No data found, just removing empty pluginSettings key");
            }
            log.debug("Removing...");
            this.pluginSettings.remove("");
            log.debug("Empty keys has been removed successfully");
        }
        catch (Exception e) {
            log.error("Failed to remove empty keys. Please remove it manually from BANDANA");
            e.printStackTrace();
        }
    }
}

