/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.action.email;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.action.email.EmailTemplatesReplacement;
import org.springframework.stereotype.Component;

@Component
public class PageLinkEmailTemplatesReplacement
implements EmailTemplatesReplacement {
    private final ApplicationProperties applicationProperties;

    @Override
    public boolean isValid(String message) {
        return message.contains("$pageLink") || message.contains("$pagelink");
    }

    @Override
    public String doAction(String message, AbstractPage abstractPage) {
        return message.replaceAll("(\\$pageLink|\\$pagelink)", this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + abstractPage.getUrlPath());
    }

    public PageLinkEmailTemplatesReplacement(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }
}

