/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerBuiltInRuleModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerBuiltInRuleSelectionModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerHistoryModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerPostFunctionModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleReplaceType;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleSearchType;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerScheduleModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTemplateModel;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTaskEntity;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTemplateEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerBuiltInRuleManager;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerRuleDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerSchedulerManager;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskManager;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTemplateDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerPostFunctionService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerResultService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerRuleService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTaskService;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerTemplateService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTemplateService.class);
    private final DataCleanerTemplateDao dataCleanerTemplateDao;
    private final DataCleanerTaskDao dataCleanerTaskDao;
    private final DataCleanerBuiltInRuleManager dataCleanerBuiltInRuleManager;
    private final DataCleanerRuleDao dataCleanerRuleDao;
    private final DataCleanerTaskManager dataCleanerTaskManager;
    private final DataCleanerTaskService dataCleanerTaskService;
    private final DataCleanerRuleService dataCleanerRuleService;
    private final DataCleanerPostFunctionService dataCleanerPostFunctionService;
    private final DataCleanerResultService dataCleanerResultService;
    private final DataCleanerSchedulerManager dataCleanerSchedulerManager;
    private final ConfigurationManager configurationManager;
    @ComponentImport
    private final CQLSearchService searchService;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final PluginSettings pluginSettings;
    private DataCleanerTemplateModel userAnonymizeTemplateModel;

    @Autowired
    public DataCleanerTemplateService(DataCleanerTemplateDao dataCleanerTemplateDao, DataCleanerTaskDao dataCleanerTaskDao, DataCleanerBuiltInRuleManager dataCleanerBuiltInRuleManager, DataCleanerRuleDao dataCleanerRuleDao, DataCleanerTaskManager dataCleanerTaskManager, DataCleanerTaskService dataCleanerTaskService, DataCleanerRuleService dataCleanerRuleService, DataCleanerPostFunctionService dataCleanerPostFunctionService, DataCleanerResultService dataCleanerResultService, DataCleanerSchedulerManager dataCleanerSchedulerManager, CQLSearchService searchService, ConfigurationManager configurationManager, UserAccessor userAccessor, @ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.dataCleanerTemplateDao = dataCleanerTemplateDao;
        this.dataCleanerTaskDao = dataCleanerTaskDao;
        this.dataCleanerBuiltInRuleManager = dataCleanerBuiltInRuleManager;
        this.dataCleanerRuleDao = dataCleanerRuleDao;
        this.dataCleanerTaskManager = dataCleanerTaskManager;
        this.dataCleanerTaskService = dataCleanerTaskService;
        this.dataCleanerRuleService = dataCleanerRuleService;
        this.dataCleanerPostFunctionService = dataCleanerPostFunctionService;
        this.dataCleanerResultService = dataCleanerResultService;
        this.dataCleanerSchedulerManager = dataCleanerSchedulerManager;
        this.searchService = searchService;
        this.configurationManager = configurationManager;
        this.userAccessor = userAccessor;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr.datacleaner.last-run");
        this.userAnonymizeTemplateModel = new DataCleanerTemplateModel();
        this.userAnonymizeTemplateModel.setId(-1);
    }

    public DataCleanerTemplateModel createDraftTemplate() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        DataCleanerTemplateEntity entity = this.dataCleanerTemplateDao.createDraftEntity(user.getName());
        return this.entityToModel(entity);
    }

    public DataCleanerTemplateModel createTemplate(DataCleanerTemplateModel templateModel) {
        Gson gson = new Gson();
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        String cql = templateModel.getCql();
        DataCleanerTemplateEntity entity = this.dataCleanerTemplateDao.createEntity(templateModel.isEnabled(), templateModel.getName(), user.getName(), cql, templateModel.getCqlType(), this.toJsonString(templateModel.getObjects()), templateModel.getNotificationType(), gson.toJson(templateModel.getNotificationParameters()));
        return this.entityToModel(entity);
    }

    public List<DataCleanerTemplateModel> getAllTemplates() {
        List<DataCleanerTemplateEntity> entities = this.dataCleanerTemplateDao.getAllEntities();
        List<DataCleanerTemplateModel> models = entities.stream().map(entity -> {
            DataCleanerTemplateModel template = this.entityToModel((DataCleanerTemplateEntity)entity);
            template.setDataRulesCount(this.dataCleanerRuleDao.getEnabledRules(entity.getID()).size());
            DataCleanerTaskEntity task = this.dataCleanerTaskDao.getByTemplateId(entity.getID());
            if (task != null) {
                template.setTask(this.dataCleanerTaskManager.entityToModel(task));
            } else {
                template.setTask(null);
            }
            template.setScheduler(this.dataCleanerSchedulerManager.getCronsForTemplate(entity.getID()));
            return template;
        }).collect(Collectors.toList());
        return models;
    }

    public DataCleanerTemplateModel getUserAnonymizeTemplateModel() {
        return this.userAnonymizeTemplateModel;
    }

    public DataCleanerTemplateModel setUserAnonymizeTemplateModel(DataCleanerTemplateModel userAnonymizeTemplateModel) {
        this.userAnonymizeTemplateModel = userAnonymizeTemplateModel;
        return this.userAnonymizeTemplateModel;
    }

    public DataCleanerTemplateModel getTemplate(int id) {
        DataCleanerTemplateModel model;
        if (id == -1) {
            model = this.getUserAnonymizeTemplateModel();
        } else {
            DataCleanerTemplateEntity entity = this.dataCleanerTemplateDao.getById(id);
            model = this.entityToModel(entity);
        }
        model.setIssueCount(this.getIssueCount(model.getCql()));
        model.setDataRulesCount(this.dataCleanerRuleService.getEnabledRules(id).size());
        DataCleanerTaskEntity taskEntity = this.dataCleanerTaskDao.getByTemplateId(id);
        if (taskEntity != null) {
            model.setTask(this.dataCleanerTaskManager.entityToModel(taskEntity));
        } else {
            model.setTask(null);
        }
        model.setScheduler(this.dataCleanerSchedulerManager.getCronsForTemplate(id));
        return model;
    }

    public void deleteTemplate(int id) throws Exception {
        Optional<DataCleanerTaskModel> activeTask = this.dataCleanerTaskService.getActiveTaskForTemplate(id);
        if (!activeTask.isPresent()) {
            List<DataCleanerTaskModel> historicalTasks = this.dataCleanerTaskService.getHistoricalTasksForTemplate(id);
            for (DataCleanerTaskModel task : historicalTasks) {
                List<DataCleanerHistoryModel> results = this.dataCleanerResultService.getResultsByTaskId(task.getId());
                results.forEach(r -> this.dataCleanerResultService.delete(r.getId()));
                this.dataCleanerTaskService.deleteTask(task.getId());
            }
        } else {
            throw new Exception("There is an active task. You can not delete this template until task will be cancelled or finished.");
        }
        List<DataCleanerRuleModel> rules = this.dataCleanerRuleService.getRules(id);
        rules.forEach(r -> this.dataCleanerRuleService.deleteRule(r.getId()));
        List<DataCleanerPostFunctionModel> postfunctions = this.dataCleanerPostFunctionService.getAllPostFunctions(id);
        postfunctions.forEach(pf -> this.dataCleanerPostFunctionService.deletePostFunction(pf.getId()));
        List<DataCleanerScheduleModel> crons = this.dataCleanerSchedulerManager.getCronsForTemplate(id);
        crons.forEach(el -> this.dataCleanerSchedulerManager.deleteCron(el.getId()));
        this.pluginSettings.remove("template-" + id);
        this.dataCleanerTemplateDao.deleteEntity(id);
    }

    public DataCleanerTemplateModel updateTemplate(int id, DataCleanerTemplateModel model) {
        DataCleanerTemplateModel newModel;
        if (id == -1) {
            this.dataCleanerRuleService.deleteRulesByTemplateId(-1);
            this.dataCleanerPostFunctionService.deleteAllPostFunctions(-1);
            newModel = this.setUserAnonymizeTemplateModel(model);
        } else {
            Gson gson = new Gson();
            ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
            String cql = model.getCql();
            DataCleanerTemplateEntity entity = this.dataCleanerTemplateDao.updateEntity(id, model.isEnabled(), false, model.getName(), applicationUser.getName(), cql, model.getCqlType(), this.toJsonString(model.getObjects()), model.getNotificationType(), gson.toJson(model.getNotificationParameters()));
            newModel = this.entityToModel(entity);
        }
        newModel.setIssueCount(this.getIssueCount(newModel.getCql()));
        return newModel;
    }

    public List<DataCleanerBuiltInRuleModel> getAllBuiltInRules() {
        return this.dataCleanerBuiltInRuleManager.getAllBuiltInRulesAsText();
    }

    public String setSelectedBuiltInRules(DataCleanerBuiltInRuleSelectionModel dataCleanerBuiltInRuleSelectionModel) {
        List<DataCleanerBuiltInRuleModel> allBuiltinRules = this.dataCleanerBuiltInRuleManager.getAllBuiltInRulesAsText();
        List<String> selectedBuiltInRules = Arrays.asList(dataCleanerBuiltInRuleSelectionModel.getSelections().split("\\s*,\\s*"));
        for (DataCleanerBuiltInRuleModel someBuiltInRule : allBuiltinRules) {
            if (!selectedBuiltInRules.contains(someBuiltInRule.getId())) continue;
            this.dataCleanerRuleDao.createEntity(dataCleanerBuiltInRuleSelectionModel.getTemplateId(), true, someBuiltInRule.getName(), DataCleanerRuleSearchType.REGEX.getType(), someBuiltInRule.getRegex(), DataCleanerRuleReplaceType.PLAIN_TEXT.getType(), someBuiltInRule.getReplaceTo());
        }
        return "success";
    }

    public void setEnabledState(int id, boolean isEnabled, String userKey) {
        this.dataCleanerTemplateDao.setEnableDisableState(id, userKey, isEnabled);
    }

    public DataCleanerTemplateModel cloneTemplate(int templateId) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        DataCleanerTemplateEntity dataCleanerTemplateEntity = this.dataCleanerTemplateDao.getById(templateId);
        DataCleanerTemplateEntity creatingTemplateEntity = this.dataCleanerTemplateDao.createEntity(dataCleanerTemplateEntity.getEnabled(), "[CLONED] " + dataCleanerTemplateEntity.getName(), user.getName(), dataCleanerTemplateEntity.getCql(), dataCleanerTemplateEntity.getCqlType(), dataCleanerTemplateEntity.getObjects(), dataCleanerTemplateEntity.getNotificationType(), dataCleanerTemplateEntity.getNotificationParameters());
        int creatingTemplateId = creatingTemplateEntity.getID();
        int diffOfRuleId = -1;
        List<DataCleanerRuleModel> rules = this.dataCleanerRuleService.getRules(templateId);
        for (DataCleanerRuleModel dataCleanerRuleModel : rules) {
            dataCleanerRuleModel.setTemplateId(creatingTemplateId);
            DataCleanerRuleModel dataCleanerRuleModel2 = this.dataCleanerRuleService.createRule(dataCleanerRuleModel);
            if (diffOfRuleId >= 0) continue;
            diffOfRuleId = dataCleanerRuleModel2.getId() - dataCleanerRuleModel.getId();
        }
        List<DataCleanerPostFunctionModel> postfunctions = this.dataCleanerPostFunctionService.getAllPostFunctions(templateId);
        for (DataCleanerPostFunctionModel postfunction : postfunctions) {
            postfunction.setTemplateId(creatingTemplateId);
            if (!postfunction.isAnyRuleEnabled()) {
                CharSequence[] items = postfunction.getRules().split("\\s*,\\s*");
                for (int i = 0; i < items.length; ++i) {
                    items[i] = Integer.toString(Integer.parseInt((String)items[i]) + diffOfRuleId);
                }
                String strItems = String.join((CharSequence)",", items);
                postfunction.setRules(strItems);
            }
            this.dataCleanerPostFunctionService.createPostFunction(postfunction);
        }
        List<DataCleanerScheduleModel> list = this.dataCleanerSchedulerManager.getCronsForTemplate(templateId);
        for (DataCleanerScheduleModel cron : list) {
            cron.setTemplateId(creatingTemplateId);
            this.dataCleanerSchedulerManager.createCron(cron);
        }
        return this.entityToModel(creatingTemplateEntity);
    }

    public boolean checkJql(String jql) {
        return true;
    }

    private int getIssueCount(String jql) {
        int issueCount = 0;
        if (jql == null || jql.length() < 1) {
            return issueCount;
        }
        ConfluenceUser serviceUser = this.userAccessor.getUserByName(this.configurationManager.getRunTasksFromUser());
        return issueCount;
    }

    private DataCleanerTemplateModel entityToModel(DataCleanerTemplateEntity templateEntity) {
        DataCleanerTemplateModel templateModel = DataCleanerTemplateModel.builder().id(templateEntity.getID()).enabled(templateEntity.getEnabled()).isDraft(templateEntity.isDraft()).name(templateEntity.getName()).cql(templateEntity.getCql()).cqlType(templateEntity.getCqlType()).objects(this.jsonStringToList(templateEntity.getObjects())).creator(templateEntity.getCreator()).creationDate(templateEntity.getCreationDate()).lastModifier(templateEntity.getLastModifier()).lastModificationDate(templateEntity.getLastModificationDate()).notificationType(templateEntity.getNotificationType()).notificationParameters(this.jsonStringToMap(templateEntity.getNotificationParameters())).build();
        return templateModel;
    }

    private Map<String, String> jsonStringToMap(String jsonString) {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        Map stringMap = (Map)gson.fromJson(jsonString, type);
        return stringMap;
    }

    private String toJsonString(Object data) {
        return new Gson().toJson(data);
    }

    private List<String> jsonStringToList(String jsonString) {
        Type type = new TypeToken<List<String>>(){}.getType();
        return (List)new Gson().fromJson(jsonString, type);
    }
}

