/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserNameConvertManager {
    @ComponentImport
    private UserAccessor userAccessor;
    private static final String UNDEFINED_USER = "[undefined]";
    private static final String ANONYMOUS_USER = "[anonymous]";

    @Autowired
    public UserNameConvertManager(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public String convertUserNameToUserKey(String userName) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userName})) {
            return ANONYMOUS_USER;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            return UNDEFINED_USER;
        }
        return user.getKey().getStringValue();
    }

    public String convertUserKeyToUserName(String userKey) {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{userKey})) {
            return ANONYMOUS_USER;
        }
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(userKey));
        if (user == null) {
            return userKey;
        }
        return user.getName();
    }
}

