/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationManager {
    public static final String TRACK_PAGE_ACCESS_STATISTICS_PROPERTY_NAME = "TRACK_PAGE_ACCESS_STATISTICS";
    public static final boolean TRACK_PAGE_ACCESS_STATISTICS_DEFAULT_VALUE = true;
    public static final String PURGE_ACCESS_STATISTICS_AFTER_PROPERTY_NAME = "PURGE_ACCESS_STATISTICS_AFTER";
    public static final Integer PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE = 30;
    private static final Integer ROWS_PER_PAGE_DEFAULT_VALUE = 20;
    private static final String ROWS_PER_PAGE_PROPERTY_NAME = "ROWS_PER_PAGE";
    private static final String RUN_TASKS_FROM_USER_PROPERTY_NAME = "RUN_TASKS_FROM_USER";
    private static final String RUN_GDPR_GROUP_PROPERTY_NAME = "RUN_GDPR_GROUP";
    private final Integer EXECUTION_HISTORY_COUNT_VALUE = 20;
    private final String EXECUTION_HISTORY_COUNT_NAME = "HISTORY_COUNT";
    private final Integer EXECUTION_ENTRIES_VALUE = 1000000;
    private final String EXECUTION_ENTRIES_NAME = "ENTRIES_NAME";
    private final String TASK_TIMEOUT = "TASK_TIMEOUT";
    private final Integer TASK_TIMEOUT_DEFAULT_VALUE = 5;
    private PluginSettings pluginSettings;

    @Autowired
    public ConfigurationManager(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr");
    }

    public Integer getRowsPerPage() {
        String rowsPerPage = (String)this.pluginSettings.get(ROWS_PER_PAGE_PROPERTY_NAME);
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return ROWS_PER_PAGE_DEFAULT_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setRowsPerPage(String rowsPerPage) {
        try {
            Integer integer = Integer.parseInt(rowsPerPage);
            if (integer <= 0 || integer > 1000) {
                rowsPerPage = String.valueOf(ROWS_PER_PAGE_DEFAULT_VALUE);
            }
        }
        catch (NumberFormatException nfe) {
            rowsPerPage = String.valueOf(ROWS_PER_PAGE_DEFAULT_VALUE);
        }
        this.pluginSettings.put(ROWS_PER_PAGE_PROPERTY_NAME, (Object)rowsPerPage);
    }

    public boolean getTrackPageAccessStatistics() {
        String trackPageAccessStatistics = (String)this.pluginSettings.get(TRACK_PAGE_ACCESS_STATISTICS_PROPERTY_NAME);
        if (Strings.isNullOrEmpty((String)trackPageAccessStatistics) || Boolean.valueOf(trackPageAccessStatistics) == null) {
            return true;
        }
        return Boolean.valueOf(trackPageAccessStatistics);
    }

    public void setTrackPageAccessStatistics(boolean trackIssueAccessStatistics) {
        this.pluginSettings.put(TRACK_PAGE_ACCESS_STATISTICS_PROPERTY_NAME, (Object)String.valueOf(trackIssueAccessStatistics));
    }

    public Integer getPurgeAccessStatisticsAfter() {
        String purgeAccessStatisticsAfter = (String)this.pluginSettings.get(PURGE_ACCESS_STATISTICS_AFTER_PROPERTY_NAME);
        if (Strings.isNullOrEmpty((String)purgeAccessStatisticsAfter) || Integer.valueOf(purgeAccessStatisticsAfter) <= 30 || Integer.valueOf(purgeAccessStatisticsAfter) > 9999) {
            return PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE;
        }
        return Integer.valueOf(purgeAccessStatisticsAfter);
    }

    public void setPurgeAccessStatisticsAfter(String purgeAccessStatisticsAfter) {
        try {
            Integer integer = Integer.parseInt(purgeAccessStatisticsAfter);
            if (integer <= 30 || integer > 9999) {
                purgeAccessStatisticsAfter = String.valueOf(PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE);
            }
        }
        catch (NumberFormatException nfe) {
            purgeAccessStatisticsAfter = String.valueOf(PURGE_ACCESS_STATISTICS_AFTER_DEFAULT_VALUE);
        }
        this.pluginSettings.put(PURGE_ACCESS_STATISTICS_AFTER_PROPERTY_NAME, (Object)purgeAccessStatisticsAfter);
    }

    public void setRunTasksFromUser(String runTasksFromUser) {
        this.pluginSettings.put(RUN_TASKS_FROM_USER_PROPERTY_NAME, (Object)runTasksFromUser);
    }

    public String getRunTasksFromUser() {
        String runTasksFromUser = (String)this.pluginSettings.get(RUN_TASKS_FROM_USER_PROPERTY_NAME);
        return runTasksFromUser;
    }

    public void setRunGdprGroup(String runGdprGroup) {
        this.pluginSettings.put(RUN_GDPR_GROUP_PROPERTY_NAME, (Object)runGdprGroup);
    }

    public String getRunGdprGroup() {
        String runGdprGroup = (String)this.pluginSettings.get(RUN_GDPR_GROUP_PROPERTY_NAME);
        return runGdprGroup;
    }

    public Integer getExecutionHistoryCount() {
        String rowsPerPage = (String)this.pluginSettings.get("HISTORY_COUNT");
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return this.EXECUTION_HISTORY_COUNT_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setExecutionHistoryCount(Integer executionHistoryCount) {
        this.pluginSettings.put("HISTORY_COUNT", (Object)String.valueOf(executionHistoryCount));
    }

    public Integer getExecutionEntriesCount() {
        String rowsPerPage = (String)this.pluginSettings.get("ENTRIES_NAME");
        if (Strings.isNullOrEmpty((String)rowsPerPage) || Integer.valueOf(rowsPerPage) <= 0) {
            return this.EXECUTION_ENTRIES_VALUE;
        }
        return Integer.valueOf(rowsPerPage);
    }

    public void setExecutionEntriesCount(Integer executionEntriesCount) {
        this.pluginSettings.put("ENTRIES_NAME", (Object)String.valueOf(executionEntriesCount));
    }

    public Integer getTaskTimeout() {
        String taskTimeout = (String)this.pluginSettings.get("TASK_TIMEOUT");
        if (Strings.isNullOrEmpty((String)taskTimeout) || Integer.valueOf(taskTimeout) <= 0) {
            return this.TASK_TIMEOUT_DEFAULT_VALUE;
        }
        return Integer.valueOf(taskTimeout);
    }

    public void setTaskTimeout(Integer timeout) {
        this.pluginSettings.put("TASK_TIMEOUT", (Object)String.valueOf(timeout));
    }
}

