define("gdpr/core/log", [], function () {
    function Logging() {
        var LEVEL = {
            DEBUG: 'DEBUG',
            INFO: 'INFO',
            WARN: 'WARN',
            ERROR: 'ERROR'
        };

        var currentLevel = LEVEL.DEBUG;

        this.debug = function (msg) {
            if (currentLevel === LEVEL.DEBUG) console.log(msg);
        };
        this.info = function (msg) {
            if (currentLevel === LEVEL.DEBUG || currentLevel === LEVEL.INFO) console.info(msg);
        };
        this.warn = function (msg) {
            if (currentLevel === LEVEL.DEBUG || currentLevel === LEVEL.INFO || currentLevel === LEVEL.WARN) console.warn(msg);
        };
        this.error = function (msg) {
            if (currentLevel === LEVEL.DEBUG || currentLevel === LEVEL.INFO || currentLevel === LEVEL.WARN || currentLevel === LEVEL.ERROR) console.error(msg);
        };
    }

    return new Logging();
});
