define("gdpr/core/rest", ["jquery"], function ($) {
    var CoreRest = {
        getLicense: function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/license",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        createLink: function (request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                dataType: "json",
                contentType: "application/json",
                data: JSON.stringify(request),
                url: AJS.contextPath() + "/rest/api/2/issueLink",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getIssueTypes: function (successCallback, errorCallback) {
            $.ajax({
                type: 'GET',
                dataType: 'json',
                url: AJS.contextPath() + '/rest/api/2/issuetype',
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getLinkTypes: function (successCallback, errorCallback) {
            $.ajax({
                type: 'GET',
                dataType: 'json',
                url: AJS.contextPath() + '/rest/api/2/issueLinkType',
                success: function (data) {
                    //log.debug(data);
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    //log.error(jqXHR);
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getProjects: function (successCallback, errorCallback) {
            $.ajax({
                type: 'GET',
                dataType: 'json',
                url: AJS.contextPath() + '/rest/api/2/project',
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getFields: function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/api/2/field",
                dataType: 'json',
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getJQLAutocomplete: function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/api/2/jql/autocompletedata",
                dataType: 'json',
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getIssues: function (postRequest, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/api/2/search",
                data: postRequest,
                dataType: "json",
                contentType: "application/json",
                cache: false,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getSprintDataForIssue: function (issueKey, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/agile/1.0/issue/" + issueKey,
                contentType: "application/json",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getSprintDetails: function (sprintId, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + '/rest/agile/1.0/sprint/' + sprintId,
                contentType: "application/json",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getCreateMeta: function (currentProject, successCallback, errorCallback) {
            $.ajax({
                type: 'GET',
                url: AJS.contextPath() + '/rest/api/2/issue/createmeta',
                dataType: 'json',
                data: {
                    projectkey: currentProject,
                    expand: "projects.issuetypes.fields"
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getIssue: function (issueKey, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/api/2/issue/" + issueKey,
                contentType: "application/json",
                cache: false,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        updateIssue: function (issueKey, request, successCallback, errorCallback) {
            $.ajax({ // PUT /rest/api/2/issue/{issueIdOrKey}
                type: "PUT",
                url: AJS.contextPath() + "/rest/api/2/issue/" + issueKey,
                data: JSON.stringify(request),
                dataType: 'json',
                contentType: "application/json",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        getIssueProperty: function (issueKey, propertyName, successCallback, errorCallback) {
            $.ajax({ // GET /rest/api/2/issue/{issueIdOrKey}/properties/{propertyKey}
                type: "GET",
                url: AJS.contextPath() + "/rest/api/2/issue/" + issueKey + "/properties/" + propertyName,
                contentType: "application/json",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        setIssueProperty: function (issueKey, propertyName, propertyNameValue, successCallback, errorCallback) {
            $.ajax({ // PUT /rest/api/2/issue/{issueIdOrKey}/properties/{propertyKey}
                type: "PUT",
                url: AJS.contextPath() + "/rest/api/2/issue/" + issueKey + "/properties/" + propertyName,
                contentType: "application/json",
                data: JSON.stringify(propertyNameValue),
                dataType: 'json',
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        },
        createIssue: function (request, successCallback, errorCallback) {
            $.ajax({
                type: 'POST',
                dataType: 'json',
                contentType: "application/json",
                data: JSON.stringify(request),
                url: AJS.contextPath() + '/rest/api/2/issue',
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
    }

    return CoreRest;
});
