/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.webwork;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.component.manager.PluginAuditManager;
import de.actonic.confluence.gdpr.component.service.ActonicLicenseService;
import de.actonic.confluence.gdpr.webwork.ExtendedConfluenceActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfigurationAction
extends ExtendedConfluenceActionSupport {
    private UserAccessor userAccessor;
    private ConfigurationManager configurationManager;
    private ActonicLicenseService actonicLicenseService;
    private PluginAuditManager pluginAuditManager;
    private static final Logger logger = LoggerFactory.getLogger(PluginConfigurationAction.class);
    private String formAction;
    private String rowsPerPage;
    private String purgeAccessStatisticsAfter;
    private String runTasksFromUser;
    private String runGdprGroup;
    private boolean trackPageAccessStatistics;
    private Integer historyCount;
    private Integer executionEntries;
    private Integer taskTimeout;

    public String execute() throws Exception {
        ConfluenceUser user;
        if ("save".equals(this.formAction)) {
            Integer auditSession = this.pluginAuditManager.saveAudit(this.rowsPerPage, this.purgeAccessStatisticsAfter, this.runTasksFromUser, this.runGdprGroup, this.trackPageAccessStatistics);
            if (auditSession == null) {
                logger.error("Can't create audit session!");
            }
            this.configurationManager.setRowsPerPage(this.rowsPerPage);
            this.configurationManager.setTrackPageAccessStatistics(this.trackPageAccessStatistics);
            this.configurationManager.setPurgeAccessStatisticsAfter(this.purgeAccessStatisticsAfter);
            user = this.userAccessor.getUserByName(this.runTasksFromUser);
            if (user != null) {
                this.configurationManager.setRunTasksFromUser(user.getKey().getStringValue());
            }
            this.configurationManager.setRunGdprGroup(this.runGdprGroup);
            this.configurationManager.setExecutionEntriesCount(this.executionEntries);
            this.configurationManager.setExecutionHistoryCount(this.historyCount);
            this.configurationManager.setTaskTimeout(this.taskTimeout);
        }
        this.data.put("rowsPerPage", this.configurationManager.getRowsPerPage());
        this.data.put("trackPageAccessStatistics", this.configurationManager.getTrackPageAccessStatistics());
        this.data.put("purgeAccessStatisticsAfter", this.configurationManager.getPurgeAccessStatisticsAfter());
        String runTasksFromUser = this.configurationManager.getRunTasksFromUser();
        if (runTasksFromUser != null && (user = this.userAccessor.getUserByKey(new UserKey(runTasksFromUser))) != null) {
            this.data.put("runTasksFromUser", user.getName());
        }
        this.data.put("runGdprGroup", this.configurationManager.getRunGdprGroup());
        this.data.put("isLicenseValid", this.actonicLicenseService.isLicenseValid());
        this.data.put("historyCount", this.configurationManager.getExecutionHistoryCount());
        this.data.put("executionEntries", this.configurationManager.getExecutionEntriesCount());
        this.data.put("taskTimeout", this.configurationManager.getTaskTimeout());
        return "success";
    }

    public void setTrackPageAccessStatistics(String trackPageAccessStatistics) {
        this.trackPageAccessStatistics = "on".equals(trackPageAccessStatistics);
    }

    public void setPurgeAccessStatisticsAfter(String purgeAccessStatisticsAfter) {
        this.purgeAccessStatisticsAfter = purgeAccessStatisticsAfter;
    }

    public void setRunTasksFromUser(String runTasksFromUser) {
        this.runTasksFromUser = runTasksFromUser;
    }

    public void setRunGdprGroup(String runGdprGroup) {
        this.runGdprGroup = runGdprGroup;
    }

    public void setRowsPerPage(String rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public void setFormAction(String formAction) {
        this.formAction = formAction;
    }

    public void setHistoryCount(Integer historyCount) {
        this.historyCount = historyCount;
    }

    public void setExecutionEntries(Integer executionEntries) {
        this.executionEntries = executionEntries;
    }

    public void setTaskTimeout(Integer taskTimeout) {
        this.taskTimeout = taskTimeout;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setActonicLicenseService(ActonicLicenseService actonicLicenseService) {
        this.actonicLicenseService = actonicLicenseService;
    }

    public void setPluginAuditManager(PluginAuditManager pluginAuditManager) {
        this.pluginAuditManager = pluginAuditManager;
    }
}

