/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.rest;

import de.actonic.confluence.gdpr.component.service.SessionService;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/sessions")
public class SessionRest {
    private static final Logger log = LoggerFactory.getLogger(SessionRest.class);
    private final SessionService sessionService;

    public SessionRest(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    @DELETE
    @Path(value="/user")
    public Response deleteUserSession(@Context HttpServletRequest httpServletRequest) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            this.sessionService.deleteUserSession(httpServletRequest);
            return Response.ok().build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

