/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAnonymizerTestListener
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(UserAnonymizerTestListener.class);
    @ComponentImport
    private final EventPublisher eventPublisher;

    @Autowired
    public UserAnonymizerTestListener(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onUserAnonymizationEvent(Properties event) {
        String emitter = event.getProperty("emitter");
        if (StringUtils.equals((CharSequence)emitter, (CharSequence)"USER_ANONYMIZATION_EVENT")) {
            log.debug("Triggered USER_ANONYMIZATION_EVENT");
            log.debug("source username = " + event.getProperty("sourceUsername"));
            log.debug("source displayName = " + event.getProperty("sourceDisplayName"));
            log.debug("source key = " + event.getProperty("sourceKey"));
            log.debug("source email = " + event.getProperty("sourceEmail"));
            log.debug("target username = " + event.getProperty("targetUsername"));
            log.debug("target displayName = " + event.getProperty("targetDisplayName"));
            log.debug("target key = " + event.getProperty("targetKey"));
            log.debug("target email = " + event.getProperty("targetEmail"));
        }
    }
}

