/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.manager;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTaskEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerHistoryDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskDao;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerTaskManager {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTaskManager.class);
    private final DataCleanerTaskDao dataCleanerTaskDao;
    private final DataCleanerHistoryDao dataCleanerHistoryDao;

    @Autowired
    public DataCleanerTaskManager(DataCleanerTaskDao dataCleanerTaskDao, DataCleanerHistoryDao dataCleanerHistoryDao) {
        this.dataCleanerTaskDao = dataCleanerTaskDao;
        this.dataCleanerHistoryDao = dataCleanerHistoryDao;
    }

    public DataCleanerTaskModel entityToModel(DataCleanerTaskEntity entity) {
        if (entity == null) {
            return null;
        }
        return DataCleanerTaskModel.builder().id(entity.getID()).templateId(entity.getTemplateId()).creator(entity.getCreator()).createDate(entity.getCreateDate()).startDate(entity.getStartDate()).endDate(entity.getEndDate()).status(entity.getStatus()).taskType(entity.getTaskType()).meta(this.jsonStringToMap(entity.getMeta())).taskCurrentNum(entity.getTaskCurrentNum()).taskTotalNum(entity.getTaskTotalNum()).taskMessage(entity.getTaskMessage()).foundObjectsCount(entity.getFoundObjectsCount()).build();
    }

    public List<DataCleanerTaskModel> entitiesToModels(List<DataCleanerTaskEntity> entities) {
        return entities.stream().map(dataCleanerTaskEntity -> this.entityToModel((DataCleanerTaskEntity)dataCleanerTaskEntity)).collect(Collectors.toList());
    }

    private Map<String, Object> jsonStringToMap(String jsonString) {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map stringMap = (Map)gson.fromJson(jsonString, type);
        return stringMap;
    }
}

