/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.actonic.confluence.gdpr.model.json.IdTextModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserPickerManager {
    private static final int MAX_USER_LIMIT = 10;
    @ComponentImport
    private final CrowdService crowdService;

    @Autowired
    public UserPickerManager(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public List<IdTextModel> searchUsers(String query) throws ServiceException {
        List<ConfluenceUser> confluenceUsers = this.doUserSearch((PageRequest)new SimplePageRequest(0, 10), query);
        ArrayList<IdTextModel> userModels = new ArrayList<IdTextModel>();
        for (ConfluenceUser user : confluenceUsers) {
            userModels.add(new IdTextModel(user.getName(), user.getFullName(), user.getEmail(), user.getKey().getStringValue()));
        }
        return userModels;
    }

    private List<ConfluenceUser> doUserSearch(PageRequest pageRequest, String searchTerm) throws ServiceException {
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        Query<String> finalQuery = this.buildSimpleUserQuery(pageRequest.getStart(), pageRequest.getLimit(), searchTerm);
        Iterator userNamesIterator = this.crowdService.search(finalQuery).iterator();
        while (userNamesIterator.hasNext()) {
            ConfluenceUser user = FindUserHelper.getUserByUsername((String)((String)userNamesIterator.next()));
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    private Query<String> buildSimpleUserQuery(int startIndex, int maxResults, String searchTerm) throws ServiceException {
        ArrayList<Property> properties = new ArrayList<Property>();
        properties.add(UserTermKeys.USERNAME);
        properties.add(UserTermKeys.DISPLAY_NAME);
        MatchMode mode = MatchMode.CONTAINS;
        String cleanToken = this.removeWildcards(searchTerm);
        ArrayList<TermRestriction> restrictions = new ArrayList<TermRestriction>();
        for (Property property : properties) {
            restrictions.add(new TermRestriction(property, mode, (Object)cleanToken));
        }
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user(), (SearchRestriction)Combine.anyOf(restrictions), (int)startIndex, (int)maxResults);
    }

    private String removeWildcards(String term) {
        String s = term;
        if (term.endsWith("*")) {
            s = term.substring(0, term.length() - 1);
        }
        if (s.startsWith("*")) {
            s = s.substring(1);
        }
        return s;
    }
}

