/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RequestDataSearchManager {
    private static final Logger log = LoggerFactory.getLogger(RequestDataSearchManager.class);
    @ComponentImport
    private ContentEntityManager contentEntityManager;
    @ComponentImport
    private SpaceManager spaceManager;
    @ComponentImport
    private PageManager pageManager;
    @ComponentImport
    private AttachmentManager attachmentManager;
    @ComponentImport
    private UserAccessor userAccessor;
    @ComponentImport
    private NotificationManager notificationManager;
    @ComponentImport
    private ContentPermissionManager contentPermissionManager;
    @ComponentImport
    private TransactionTemplate transactionTemplate;

    @Autowired
    public RequestDataSearchManager(@Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, SpaceManager spaceManager, PageManager pageManager, AttachmentManager attachmentManager, UserAccessor userAccessor, NotificationManager notificationManager, ContentPermissionManager contentPermissionManager, TransactionTemplate transactionTemplate) {
        this.contentEntityManager = contentEntityManager;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.attachmentManager = attachmentManager;
        this.userAccessor = userAccessor;
        this.notificationManager = notificationManager;
        this.contentPermissionManager = contentPermissionManager;
        this.transactionTemplate = transactionTemplate;
    }

    public Optional<Boolean> findUserMentions(Long entityId, ConfluenceUser user) {
        return (Optional)this.transactionTemplate.execute(() -> {
            ContentEntityObject entity = this.contentEntityManager.getById(entityId.longValue());
            String body = entity.getBodyAsString();
            Boolean result = StringUtils.containsIgnoreCase((CharSequence)body, (CharSequence)user.getKey().getStringValue());
            return result != false ? Optional.of(result) : Optional.empty();
        });
    }

    public Optional<List<Long>> findUserMentionsInComments(ContentEntityObject entity, ConfluenceUser user) {
        ArrayList results = Lists.newArrayList();
        for (Comment comment : entity.getComments()) {
            Optional<Boolean> findInComment = this.findUserMentions(comment.getId(), user);
            if (!findInComment.isPresent()) continue;
            results.add(comment.getId());
        }
        return results.size() > 0 ? Optional.of(results) : Optional.empty();
    }

    public Optional<Boolean> equalsCreatorOrLastModifier(Space space, ConfluenceUser user) {
        if (space.getCreator() != null && space.getCreator().equals(user)) {
            return Optional.of(Boolean.TRUE);
        }
        if (space.getLastModifier() != null && space.getLastModifier().equals(user)) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<Boolean> equalsCreatorOrLastModifier(ContentEntityObject entity, ConfluenceUser user) {
        if (entity.getCreator() != null && entity.getCreator().equals(user)) {
            return Optional.of(Boolean.TRUE);
        }
        if (entity.getLastModifier() != null && entity.getLastModifier().equals(user)) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<List<Long>> equalsCreatorOrLastModifierInComments(ContentEntityObject entity, ConfluenceUser user) {
        ArrayList results = Lists.newArrayList();
        for (Comment comment : entity.getComments()) {
            Optional<Boolean> equalsInComment = this.equalsCreatorOrLastModifier((ContentEntityObject)comment, user);
            if (!equalsInComment.isPresent()) continue;
            results.add(comment.getId());
        }
        return results.size() > 0 ? Optional.of(results) : Optional.empty();
    }

    public Optional<List<Long>> equalsCreatorOrLastModifierInVersionPage(ContentEntityObject entity, ConfluenceUser user) {
        ArrayList results = Lists.newArrayList();
        ContentEntityObject versionedEntity = entity;
        while ((versionedEntity = this.pageManager.getPreviousVersion(versionedEntity)) != null) {
            Optional<Boolean> equalsInVersion = this.equalsCreatorOrLastModifier(versionedEntity, user);
            if (!equalsInVersion.isPresent()) continue;
            results.add(versionedEntity.getId());
        }
        return results.size() > 0 ? Optional.of(results) : Optional.empty();
    }

    public Optional<List<Long>> equalsCreatorOrLastModifierInAttachments(ContentEntityObject entity, ConfluenceUser user) {
        ArrayList results = Lists.newArrayList();
        for (Attachment attachment : entity.getAttachments()) {
            Optional<Boolean> equalsInAttach = this.equalsCreatorOrLastModifier((ContentEntityObject)attachment, user);
            if (!equalsInAttach.isPresent()) continue;
            results.add(attachment.getId());
        }
        return results.size() > 0 ? Optional.of(results) : Optional.empty();
    }

    public Optional<List<Long>> equalsCreatorOrLastModifierInVersionAttachment(ContentEntityObject entity, ConfluenceUser user) {
        ContentEntityObject versionedEntity;
        ArrayList results = Lists.newArrayList();
        while ((versionedEntity = (ContentEntityObject)this.attachmentManager.getPreviousVersions((Attachment)entity)) != null) {
            Optional<Boolean> equalsInAttach = this.equalsCreatorOrLastModifier(versionedEntity, user);
            if (!equalsInAttach.isPresent()) continue;
            results.add(versionedEntity.getId());
        }
        return results.size() > 0 ? Optional.of(results) : Optional.empty();
    }

    public Optional<Boolean> equalsCreatorOrLastModifierWithAllVersions(ContentEntityObject lastVersionEntity, ConfluenceUser user) {
        if (this.equalsCreatorOrLastModifier(lastVersionEntity, user).isPresent()) {
            return Optional.of(Boolean.TRUE);
        }
        if (this.equalsCreatorOrLastModifierInVersionPage(lastVersionEntity, user).isPresent()) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.empty();
    }

    public Optional<HashMap<String, List<Long>>> getNotificationsForUser(ConfluenceUser user) {
        List notifications = this.notificationManager.getNotificationsByUser((User)user);
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        ArrayList pageIds = Lists.newArrayList();
        ArrayList spaceIds = Lists.newArrayList();
        for (Notification notification : notifications) {
            if (notification.getType() == ContentTypeEnum.SPACE) {
                spaceIds.add(notification.getSpace().getId());
            }
            if (notification.getType() != ContentTypeEnum.PAGE && notification.getType() != ContentTypeEnum.BLOG) continue;
            pageIds.add(notification.getContent().getId());
        }
        if (spaceIds.size() > 0) {
            map.put("space", spaceIds);
        }
        if (pageIds.size() > 0) {
            map.put("page", pageIds);
        }
        return map.size() > 0 ? Optional.of(map) : Optional.empty();
    }
}

