/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.common.datacleaner.rest;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerBuiltInRuleSelectionModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTemplateModel;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.component.manager.CqlManager;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerExecuteService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTemplateService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/data-cleaner-template")
@Produces(value={"application/json"})
public class DataCleanerTemplateRest {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTemplateRest.class);
    private final DataCleanerExecuteService dataCleanerExecuteService;
    private final DataCleanerTemplateService dataCleanerTemplateService;
    private final ConfigurationManager configurationManager;
    private final CqlManager cqlManager;
    @ComponentImport
    private final UserAccessor userAccessor;

    public DataCleanerTemplateRest(DataCleanerExecuteService dataCleanerExecuteService, DataCleanerTemplateService dataCleanerTemplateService, CqlManager cqlManager, ConfigurationManager configurationManager, UserAccessor userAccessor) {
        this.dataCleanerExecuteService = dataCleanerExecuteService;
        this.dataCleanerTemplateService = dataCleanerTemplateService;
        this.cqlManager = cqlManager;
        this.configurationManager = configurationManager;
        this.userAccessor = userAccessor;
    }

    @GET
    @Path(value="/")
    public Response getAllTemplates() {
        return this.toJsonOkResponse(this.dataCleanerTemplateService.getAllTemplates());
    }

    @GET
    @Path(value="/{id}")
    public Response getTemplate(@PathParam(value="id") int id) {
        return this.toJsonOkResponse(this.dataCleanerTemplateService.getTemplate(id));
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteTemplate(@PathParam(value="id") int id) {
        try {
            this.dataCleanerTemplateService.deleteTemplate(id);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Path(value="/draft")
    @Consumes(value={"application/json"})
    public Response createDraftTemplate() {
        return Response.ok((Object)Integer.toString(this.dataCleanerTemplateService.createDraftTemplate().getId()), (String)"text/plain").build();
    }

    @PUT
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response createTemplate(DataCleanerTemplateModel dataCleanerTemplateModel) {
        return this.toJsonOkResponse(this.dataCleanerTemplateService.createTemplate(dataCleanerTemplateModel));
    }

    @POST
    @Path(value="/{id}")
    public Response updateTemplate(@PathParam(value="id") int id, DataCleanerTemplateModel dataCleanerTemplateModel) {
        return this.toJsonOkResponse(this.dataCleanerTemplateService.updateTemplate(id, dataCleanerTemplateModel));
    }

    @GET
    @Path(value="/build-in")
    @Consumes(value={"application/json"})
    public Response getAllBuiltInRules() {
        return this.toJsonOkResponse(this.dataCleanerTemplateService.getAllBuiltInRules());
    }

    @POST
    @Path(value="/build-in")
    @Consumes(value={"application/json"})
    public Response setSelectedBuiltInRule(DataCleanerBuiltInRuleSelectionModel dataCleanerBuiltInRuleSelectionModel) {
        return this.toJsonOkResponse(this.dataCleanerTemplateService.setSelectedBuiltInRules(dataCleanerBuiltInRuleSelectionModel));
    }

    @POST
    @Path(value="/check-match")
    public Response setSelectedBuiltInRule(@FormParam(value="templateId") int templateId, @FormParam(value="ceo") Long ceoId) {
        return this.toJsonOkResponse(this.dataCleanerExecuteService.checkRulesAndTicketMatches(templateId, ceoId));
    }

    @GET
    @Path(value="/status")
    public Response getDataRulesConfigurationStatus() {
        String serviceUserName = this.configurationManager.getRunTasksFromUser();
        if (Strings.isNullOrEmpty((String)serviceUserName)) {
            return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"status", (Object)"error", (Object)"message", (Object)"Service user is empty"))).build();
        }
        ConfluenceUser applicationUser = this.userAccessor.getUserByKey(new UserKey(serviceUserName));
        if (applicationUser == null) {
            return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"status", (Object)"error", (Object)"message", (Object)("Wrong service user name " + serviceUserName)))).build();
        }
        return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"status", (Object)"ok", (Object)"message", (Object)""))).build();
    }

    @PUT
    @Path(value="/clone/{templateId}")
    public Response cloneTemplate(@PathParam(value="templateId") int templateId) {
        return this.toJsonOkResponse(this.dataCleanerTemplateService.cloneTemplate(templateId));
    }

    @POST
    @Path(value="/check-cql")
    public Response checkCql(@FormParam(value="cql") String cql) {
        return Response.ok((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"success", this.cqlManager.isCqlValid(cql)))).build();
    }

    private Response toJsonOkResponse(Object obj) {
        return Response.ok((Object)new Gson().toJson(obj)).build();
    }
}

