require(["jquery", "actonic-gdpr/request-my-data/rest", "actonic-gdpr/domReady"], function($, Rest, domReady) {
    domReady(function () {
        new Execute().init();
    });

    function Execute() {
        this.init = function () {
            $("#pagination-items").auiSelect2({
                minimumResultsForSearch: Infinity
            });
            $("#filter-select").auiSelect2({
                minimumResultsForSearch: Infinity
            });
            $("#filter-order-by").auiSelect2({
                minimumResultsForSearch: Infinity
            });

            $("#pagination-items").on("change", function () {
                filter();
            })

            $("#filter-select").on("change", function () {
                filter();
            });

            $("#filter-order-by").on("change", function () {
                filter();
            });

            $("#button-export").on("click", function () {
                fileExport();
            });

            getGeneralResult(getUser());
            filter();
        }

        function filter() {
            getPage(getUser(), getRowsPerPage(), getRelationType(), getOrderBy(), 1);
        }

        function fileExport() {
            var params = {
                user: getUser(),
                relationType: getRelationType(),
                orderBy: getOrderBy()
            };
            Rest.fileExport(params, function (data) {
                window.location = data;
            }, function (xhr) {

            })
        }

        function getGeneralResult(user) {
            Rest.getGeneralResults(user, function(data) {
                if (!data.error) {
                    var soyData = {
                        data: data
                    }
                    $("#result-request-main").html(ACTONIC.GDPR.RMD.resultgeneral(soyData));
                }
            }, function (xhr) {
            })
        }

        function getPage(user, rowsPerPage, relationType, orderBy, page) {
            var params = {
                user: user,
                rowsPerPage: rowsPerPage,
                relationType: relationType,
                orderBy: orderBy,
                page: page
            }
            Rest.getResults(params, function(data) {
                //console.log(data);
                if (data) {
                    if (!data.error) {
                        var soyData = {
                            data: data.items,
                            page: data.page,
                            totalPages: data.totalPages,
                            baseUrl: AJS.contextPath()
                        };
                        $("#result-request").html(ACTONIC.GDPR.RMD.result(soyData));

                        $(".pagination-container aui-badge").off("click");
                        $(".pagination-container aui-badge").on("click", function () {
                            var pageNumber = $(this).attr("data-page");
                            getPage(getUser(), getRowsPerPage(), getRelationType(), getOrderBy(), pageNumber);
                        });
                    } else {
                        $("#result-request").html(data.error);
                        $("#filter-select").disable();
                    }
                } else {
                    $("#result-request").html(ACTONIC.GDPR.RMD.empty());
                    $("#filter-select").disable();
                }
            }, function (xhr) {

            });

        }

        function getUser() {
            var url = new URL(window.location.href);
            var user = url.searchParams.get("user");
            if (user == null || user == "")
                user = AJS.Meta.get("remote-user");
            return user;
        }

        function getRowsPerPage() {
            return $("#pagination-items")[0].value;
        }

        function getRelationType() {
            return $("#filter-select")[0].value;
        }

        function getOrderBy() {
            return $("#filter-order-by")[0].value;
        }
    }

    return new Execute();
})