define("gdpr/core/utils", ["jquery"], function ($) {

    function Util() {
        var _this = this;
        this.getParameterByName = function (url, name) {
            name = name.replace(/[\[\]]/g, "\\$&");
            var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';

            return decodeURIComponent(results[2].replace(/\+/g, " "));
        }

        this.getCurrentUrlParameterByName = function (name) {
            return _this.getParameterByName(window.location.href, name);
        }

        this.isEmailValid = function (name) {
            var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
            return re.test(String(name).toLowerCase());
        }

        this.getWinNumericaSize = function(windowSize) {
            var windowSize = windowSize ? windowSize : "medium";

            if(windowSize == "small") return 30;
            else if(windowSize == "medium") return 50;
            else if(windowSize == "large") return 70;
            else if(windowSize == "xlarge") return 90;
        }

        this.getQuestionnaire = function() {
            var tempQue = $("#questionnaire").val();
            return {questionnaire: tempQue ? tempQue : ""};
        }
    }

    return new Util();
});

