/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpacePermissionChanger
extends BasicContentChanger {
    private static final Logger log = LoggerFactory.getLogger(SpacePermissionChanger.class);
    public static final String NAME = "changeUserPermissions";
    @ComponentImport
    private PermissionManager permissionManager;
    @ComponentImport
    private PageManager pageManager;
    @ComponentImport
    private SpaceManager spaceManager;
    @ComponentImport
    private TransactionTemplate transactionTemplate;
    @ComponentImport
    private ContentPermissionManager contentPermissionManager;

    @Autowired
    protected SpacePermissionChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, PermissionManager permissionManager, PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentPermissionManager contentPermissionManager) {
        super(pluginSettingsFactory, transactionTemplate);
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.transactionTemplate = transactionTemplate;
        this.contentPermissionManager = contentPermissionManager;
    }

    @Override
    public boolean isAffected(EntityObject pissue, ConfluenceUser user) {
        return (Boolean)this.transactionTemplate.execute(() -> {
            try {
                log.debug(">> spacePermissionChanger (isAffected) > trying to get space with spaceKey=" + ((Space)pissue).getKey());
                Space space = this.spaceManager.getSpace(((Space)pissue).getKey());
                if (space != null && space.getPermissions() != null) {
                    log.debug(">> spacePermissionChanger (isAffected) > space found");
                    for (SpacePermission permission : space.getPermissions()) {
                        if (permission == null || permission.getUserSubject() == null || !permission.getUserSubject().equals(user)) continue;
                        log.debug(">> spacePermissionChanger (isAffected) > affectedPermissions found");
                        return true;
                    }
                    log.debug(">> spacePermissionChanger (isAffected) > affectedPermissions NOT found");
                }
            }
            catch (Exception e) {
                log.error(e.getMessage());
                log.error(e.getStackTrace().toString());
                e.printStackTrace();
            }
            return false;
        });
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Updating user permissions...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        log.debug(">> spacePermissionChanger (change) > executing for space=" + ((Space)issue).getKey());
        log.debug(">> spacePermissionChanger (change) > isAffected?");
        if (this.isAffected(issue, sourceUser)) {
            changesTotal = changesTotal + ((Space)issue).getKey() + ", ";
            boolean transactionResult = (Boolean)this.transactionTemplate.execute(() -> {
                try {
                    log.debug(">> spacePermissionChanger (change) > trying to get spacePermissions");
                    Space space = this.spaceManager.getSpace(((Space)issue).getKey());
                    ArrayList spacePermissionList = Lists.newArrayList();
                    log.debug(">> spacePermissionChanger (change) > spaceFound=" + (space != null) + ", permissionsHaveSize=" + (space != null && space.getPermissions() != null && space.getPermissions().size() > 0));
                    if (space != null && space.getPermissions() != null) {
                        spacePermissionList.addAll(space.getPermissions());
                        log.debug(">> spacePermissionChanger (change) > trying to change spacePermisions");
                        for (SpacePermission permission : spacePermissionList) {
                            if (!permission.isUserPermission() || !permission.getUserSubject().equals(sourceUser)) continue;
                            SpacePermission newPermission = SpacePermission.createUserSpacePermission((String)permission.getType(), (Space)space, (ConfluenceUser)targetUser);
                            space.removePermission(permission);
                            space.addPermission(newPermission);
                        }
                        log.debug(">> spacePermissionChanger (change) > trying to save space");
                        this.spaceManager.saveSpace(space);
                        log.debug(">> spacePermissionChanger (change) > success");
                    }
                    return true;
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    log.error(e.getStackTrace().toString());
                    e.printStackTrace();
                    return false;
                }
            });
            if (transactionResult) {
                changesSuccess = changesSuccess + ((Space)issue).getKey() + ", ";
            } else {
                changesFail = changesFail + ((Space)issue).getKey() + ", ";
            }
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }
}

