/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IntroManager {
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Autowired
    public IntroManager(PluginSettingsFactory pluginSettingsFactory, UserAccessor userAccessor) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.userAccessor = userAccessor;
    }

    public boolean isIntroShowed(String moduleName, String userName) throws Exception {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            throw new Exception("User not found " + userName);
        }
        String userKey = user.getKey().getStringValue();
        PluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(this.getClass().getPackage().getName() + "-" + moduleName);
        Object firstVisitTime = pluginSettings.get(userKey);
        if (firstVisitTime == null) {
            pluginSettings.put(userKey, (Object)String.valueOf(new Date().getTime()));
            return false;
        }
        return true;
    }

    public void deleteIntroMarker(String moduleName, String userName) throws Exception {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            throw new Exception("User not found " + userName);
        }
        PluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(this.getClass().getPackage().getName() + "-" + moduleName);
        pluginSettings.remove(userName);
    }
}

