define("actonic-gdpr/request-my-data/rest", ["jquery"], function ($) {
    function Rest() {
        this.createRequest = function (user, successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/request-my-data/request",
                type: "POST",
                headers: {"X-Atlassian-Token": "no-check"},
                data: {
                    user: user
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };
        this.getRequest = function (user, successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/request-my-data/request",
                type: "GET",
                data: {
                    user: user
                },
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };
        this.cancelRequest = function (id, successCallback, errorCallback) {
            var params = {
                id: id
            };
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/request-my-data/request",
                type: "DELETE",
                data: params,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }
        this.getResults = function (params, successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/request-my-data/results"
                    + "?user=" + params.user
                    + "&rowsPerPage=" + params.rowsPerPage
                    + "&relationType=" + params.relationType
                    + "&orderBy=" + params.orderBy
                    + "&page=" + params.page,
                type: "GET",
                data: params,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };
        this.getGeneralResults = function (user, successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/request-my-data/results/general?user=" + user,
                type: "GET",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };
        this.getHistory = function (successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/request-my-data/history",
                type: "GET",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };
        this.getRequestQueue = function (successCallback, errorCallback) {
            $.ajax({
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/request-my-data/queue",
                type: "GET",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };
        this.fileExport = function (params, successCallback, errorCallback) {
            var url = AJS.contextPath() + "/rest/actonic-gdpr/1.0/request-my-data/export"
                + "?user=" + params.user
                + "&relationType=" + params.relationType
                + "&orderBy=" + params.orderBy;
            $.ajax({
                url: url,
                type: "GET",
                data: params,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(url);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        };
    }

    return new Rest();
})