require(["jquery", "actonic-gdpr/data-level-agreement/rest", "actonic-gdpr/core/flags", "actonic-gdpr/announcing/rest", "actonic-gdpr/user-anonymizer/rest", "actonic-gdpr/domReady"],
    function ($, DateRulesRest, flags, AnnouncingRest, AnonymizerRest, domReady) {
    domReady(function () {
        new Home().init();
    });

    function Home() {
        this.init = function () {
            getAnnouncingItems();
            getAllRules();
            // getAllAnonymizationRequests();
            checkForProperPluginConfiguration();
        }

        function getAllRules() {
            DateRulesRest.getAllRules(
                function (data) { // success
                    $("#data-rule-progress-indicator").hide();
                    // log.debug("Rest.getAllRules data = " + JSON.stringify(data));
                    var atLeastOneEnabledDataRule = false;
                    if (data && data.length > 0) {
                        data.forEach(function (item) {
                            if (item.isActive) {
                                atLeastOneEnabledDataRule = true;
                                $("#data-rule-wrapper").append(ACTONIC.GDPR.HOME.getDataRuleRow({id: item.id, name: item.name}));
                            }
                        });
                    }

                    if (atLeastOneEnabledDataRule)
                        $("#data-rule-wrapper").show();
                    else
                        $("#data-rule-none").show();
                },
                function (error) {
                    $("#data-rule-progress-indicator").hide();
                    flags.showFlag(AJS.I18n.getText("js-home.error"), AJS.I18n.getText("js-home.data-rules.error.desc") + " " + JSON.stringify(error), "error");
                });
        }

        function getAnnouncingItems() {
            AnnouncingRest.getNewAnnouncements(
                function (data) { // success
                    $("#announcements-progress-indicator").hide();
                    //log.debug("Rest.getAnnouncingItems data = " + JSON.stringify(data));
                    var atLeastOneEnabledAnnouncement = false;
                    if (data.items && data.items.length > 0) {
                        data.items.forEach(function (item) {
                            let contextPath = AJS.contextPath();
                            atLeastOneEnabledAnnouncement = true;
                            $("#announcements-wrapper").append(ACTONIC.GDPR.HOME.getAnnouncementRow({id: item.id, name: item.name, contextPath}));
                        });

                        $(document).on('click','#announcer-link', function (event) {
                            var href = $(this).attr('href');
                            var id = href.match(/\/announcement\/(\d+)/)[1];
                            event.stopPropagation();

                            AnnouncingRest.getDraftAnnouncements(id,
                                function (draft) { // success
                                    if (draft == null) {
                                        AnnouncingRest.updateNewAnnouncement(id, {id: id},
                                            function (updatedDraft) {
                                                window.location.href = href;
                                            },
                                            function (error) { // error
                                                flags.showFlag(AJS.I18n.getText("js-announcing.edit-page.rest.get-announcing.error.title"), AJS.I18n.getText("js-announcing.edit-page.rest.announcing.error.desc") + " " + JSON.stringify(error.responseText), "error");
                                            });
                                    } else {
                                        window.location.href = href;
                                    }
                                },
                                function (error) { // error
                                    flags.showFlag(AJS.I18n.getText("js-announcing.edit-page.rest.get-announcing.error.title"), AJS.I18n.getText("js-announcing.edit-page.rest.announcing.error.desc") + " " + JSON.stringify(error.responseText), "error");
                                });
                            return false;
                        });

                    }

                    if (atLeastOneEnabledAnnouncement)
                        $("#announcements-wrapper").show();
                     else
                        $("#announcements-none").show();
                },
                function (error) { // error
                    $("#announcements-progress-indicator").hide();
                    flags.showFlag(AJS.I18N.getText("js-home.error"), AJS.I18N.getText("js-home.announcement.error.desc") + " " + JSON.stringify(error.responseText), "error");
                });
        }

        function getAllAnonymizationRequests() {
            AnonymizerRest.getErasureRequests(
                function (data) { // success
                    $("#anonymizer-progress-indicator").hide();
                    //log.debug("Rest.getErasureRequests data = " + JSON.stringify(data));
                    var atLeastOneAnonymizationRequest = false;
                    if (data && data.length > 0) {
                        data.forEach(function (item) {
                            if (item.statusCode == 1) {
                                atLeastOneAnonymizationRequest = true;
                                $("#anonymizer-wrapper").append(ACTONIC.GDPR.HOME.getAnpnymizerRow({userName: item.userName}));
                            }
                        });
                    }

                    if (atLeastOneAnonymizationRequest)
                        $("#anonymizer-wrapper").show();
                    else
                        $("#anonymizer-none").show();
                },
                function (error) {
                    $("#anonymizer-progress-indicator").hide();
                    flags.showFlag(AJS.I18N.getText("js-home.error"), AJS.I18N.getText("js-home.anonymization.error.desc") + " " + JSON.stringify(error), "error");
                });
        }

        function checkForProperPluginConfiguration() {
            DateRulesRest.getDataRulesConfigurationStatus(
                function (data) {
                    if (!data || data.status == "error") {
                        $("#configuration-looks-bad").show();
                    } else {
                        $("#configuration-looks-good").show();
                    }
                },
                function (error) {
                    log.error("Rest.getDataRulesConfigurationStatus error = " + JSON.stringify(error));
                    flags.showFlag(AJS.I18N.getText("js-home.error"), AJS.I18N.getText("js-home.config.error.desc") + " " + JSON.stringify(error), "error");
                });
        }
    }

    return new Home();
});