/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.scheduling;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.component.service.AccessStatisticsService;
import de.actonic.confluence.gdpr.scheduling.AccessStatPurgeJob;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class AccessStatPurgeJobStarter
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(AccessStatPurgeJobStarter.class);
    private static final String JOB_NAME = AccessStatPurgeJob.class.getName() + ":job";
    private final ConfigurationManager configurationManager;
    private final AccessStatisticsService accessStatisticsService;
    @ComponentImport
    private final PluginScheduler pluginScheduler;
    private final long interval = 86400000L;

    @Autowired
    public AccessStatPurgeJobStarter(ConfigurationManager configurationManager, PluginScheduler pluginScheduler, AccessStatisticsService accessStatisticsService) {
        this.configurationManager = configurationManager;
        this.pluginScheduler = pluginScheduler;
        this.accessStatisticsService = accessStatisticsService;
    }

    public void onStart() {
        this.reschedule();
    }

    @PreDestroy
    public void onStop() {
        this.pluginScheduler.unscheduleJob(JOB_NAME);
    }

    public void reschedule() {
        this.pluginScheduler.scheduleJob(JOB_NAME, AccessStatPurgeJob.class, (Map)new HashMap<String, Object>(){
            {
                this.put("purgeAccessStatisticsAfter", AccessStatPurgeJobStarter.this.configurationManager.getPurgeAccessStatisticsAfter());
                this.put("accessStatisticsService", AccessStatPurgeJobStarter.this.accessStatisticsService);
            }
        }, new Date(), 86400000L);
    }
}

