/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.HashMap;

public abstract class BasicContentChanger {
    public static final String JOB_STATUS_KEY = "de.actonic.confluence.gdpr.component.service.UserAnonymizerService";
    private final PluginSettings pluginSettings;
    private final TransactionTemplate transactionTemplate;

    protected BasicContentChanger(PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(JOB_STATUS_KEY);
        this.transactionTemplate = transactionTemplate;
    }

    public String getAffectedContent(EntityObject issue, ConfluenceUser sourceUser) {
        String affectedContent = "";
        if (issue != null && this.isAffected(issue, sourceUser)) {
            affectedContent = issue.getId() + ", ";
        }
        return affectedContent;
    }

    abstract boolean isAffected(EntityObject var1, ConfluenceUser var2);

    abstract ContentChangerResult changeIssues(String var1, EntityObject var2, ConfluenceUser var3, ConfluenceUser var4);

    abstract String getChangerName();

    protected void setJobMessage(String jobId, String message) {
        HashMap<String, String> messageMap = new HashMap<String, String>();
        messageMap.put("status", "in progress");
        messageMap.put("message", message);
        this.pluginSettings.put(jobId, (Object)new Gson().toJson(messageMap));
    }
}

