define("gdpr/data-cleaner/pii-template", ["jquery", "gdpr/data-cleaner/rest", "gdpr/data-cleaner/task", "gdpr/core/log", "gdpr/data-cleaner/rules/rest"], function ($, TemplatesRest, DataCleanerTasks, log, RulesRest) {
    function PIITemplate() {
        this.init = function () {
            if (!$("#confirm-create-pii-template").length) $("body").append(ACTONIC.GDPR.DATACLEANER.MAIN.createPiiDialog());

            $("#anonymize-pii").click(showCreateTemplateForPIIDialog);
            $("#create-pii-template-btn").click(createTemplateForPII);
            $("#cancel-create-pii-template-btn").click(hideCreateTemplateForPIIDialog);
        };

        function showCreateTemplateForPIIDialog() {
            AJS.dialog2("#confirm-create-pii-template").show();
        }

        function hideCreateTemplateForPIIDialog() {
            AJS.dialog2("#confirm-create-pii-template").hide();
        }

        function createTemplateForPII() {
            var request = {
                type: "custom",
                action: "create"
            };
            TemplatesRest.draft(request, function (templateId) {
                //log.debug("Rest.draft data = " + JSON.stringify(templateId));
                var templateDraftContent = {
                    name: AJS.I18n.getText("js-data-clean.template.pii.text.one"),
                    cql: "type in (page, blogpost)",
                    objects: ["title", "body", "comment"],
                    notificationType: "none"
                };
                TemplatesRest.update(templateId, templateDraftContent, function (templateContent) {
                    //log.debug("data-cleaner-template data = " + JSON.stringify(templateContent));
                    var selectedRules = "phone-1,other-1,other-2";
                    RulesRest.setSelectedBuildIn(templateId, selectedRules, function (data) {
                            //log.debug("Rest.setSelectedBuildIn data = " + JSON.stringify(data));
                            var postFunctionContent = {
                                name: AJS.I18n.getText("js-data-clean.template.pii.text.three"),
                                rules: "",
                                notificationType: "comment",
                                anyRuleEnabled: true,
                                notificationParameters: {comment: AJS.I18n.getText("js-data-clean.template.pii.text.two")},
                                templateId: templateId
                            };
                            //log.debug("postFunctionContent = " + JSON.stringify(postFunctionContent));
                            RulesRest.createPostFunction(postFunctionContent,
                                function () {
                                    window.location = AJS.contextPath() + "/admin/actonic-gdpr/edit-data-cleaner-template.action?id=" + templateId;
                                }, function (error) {
                                    log.error("RulesRest.createPostFunction error = " + JSON.stringify(error));
                                });
                        }, function (error) {
                            log.error("RulesRest.setSelectedBuildIn error = " + JSON.stringify(error));
                        }
                    );
                }, function (error) {
                    log.error("TemplatesRest.update error = " + JSON.stringify(error));
                });
            }, function (error) {
                log.error("TemplatesRest.draft error = " + JSON.stringify(error));
            });
        }
    }

    return new PIITemplate();
});
