/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TitleChanger
implements Changer {
    private static final Logger log = LoggerFactory.getLogger(TitleChanger.class);
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final ContentEntityObjectDao contentEntityObjectDao;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    @Autowired
    public TitleChanger(PageManager pageManager, ContentEntityObjectDao contentEntityObjectDao, TransactionTemplate transactionTemplate, DraftsTransitionHelper draftsTransitionHelper) {
        this.pageManager = pageManager;
        this.contentEntityObjectDao = contentEntityObjectDao;
        this.transactionTemplate = transactionTemplate;
        this.draftsTransitionHelper = draftsTransitionHelper;
    }

    @Override
    public String getType() {
        return "text";
    }

    @Override
    public List<String> extractValues(Long ceoId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject ceo = this.pageManager.getById(ceoId.longValue());
            return ceo != null ? Lists.newArrayList((Object[])new String[]{ceo.getTitle()}) : Lists.newArrayList();
        });
    }

    @Override
    public void applyNewValues(Long ceoId, Map<String, String> oldNewValuesMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject tCeo = this.pageManager.getById(ceoId.longValue());
            String title = tCeo.getTitle();
            for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                title = (String)entry.getValue();
            }
            title = this.fixPageTitle(title, tCeo);
            tCeo.setTitle(title);
            this.pageManager.saveContentEntity(tCeo, this.SAVE_CONTEXT);
            ContentEntityObject draft = this.draftsTransitionHelper.getDraftForPage((AbstractPage)tCeo);
            if (draft != null) {
                draft.setTitle(title);
                this.pageManager.saveContentEntity(draft, this.SAVE_CONTEXT);
            }
            return true;
        });
    }

    protected List<ContentEntityObject> getVersionList(ContentEntityObject versionPage) {
        ArrayList versions = Lists.newArrayList();
        versions.add(versionPage);
        while ((versionPage = this.pageManager.getPreviousVersion(versionPage)) != null) {
            versions.add(versionPage);
        }
        return versions;
    }

    private String fixPageTitle(String currentTitle, ContentEntityObject currentCeo) {
        String fixedTitle;
        block3: {
            Integer counter;
            block2: {
                fixedTitle = currentTitle;
                counter = 1;
                if (!(currentCeo instanceof Page)) break block2;
                while (this.pageManager.getPage(((Page)currentCeo).getSpaceKey(), fixedTitle) != null) {
                    fixedTitle = currentTitle + " (" + counter + ")";
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                }
                break block3;
            }
            if (!(currentCeo instanceof BlogPost)) break block3;
            while (this.pageManager.getBlogPost(((BlogPost)currentCeo).getSpaceKey(), fixedTitle, ((BlogPost)currentCeo).getPostingCalendarDate()) != null) {
                fixedTitle = currentTitle + " (" + counter + ")";
                Integer n = counter;
                Integer n3 = counter = Integer.valueOf(counter + 1);
            }
        }
        return fixedTitle;
    }
}

