/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerCreateTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerRuleSearchType;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTemplateModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.TaskRequestStatusEnum;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.component.service.ActonicLicenseService;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTaskEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskManager;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleaner3dPartyAddonService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerRuleService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerTaskService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTaskService.class);
    private final DataCleanerTaskDao dataCleanerTaskDao;
    private final DataCleanerRuleService dataCleanerRuleService;
    private final DataCleanerTaskManager dataCleanerTaskManager;
    private final DataCleaner3dPartyAddonService dataCleaner3dPartyAddonService;
    private final ActonicLicenseService actonicLicenseService;
    private final ConfigurationManager configurationManager;
    private final UserAccessor userAccessor;

    @Autowired
    public DataCleanerTaskService(DataCleanerTaskDao dataCleanerTaskDao, DataCleanerRuleService dataCleanerRuleService, DataCleanerTaskManager dataCleanerTaskManager, DataCleaner3dPartyAddonService dataCleaner3dPartyAddonService, ActonicLicenseService actonicLicenseService, ConfigurationManager configurationManager, UserAccessor userAccessor) {
        this.dataCleanerTaskDao = dataCleanerTaskDao;
        this.dataCleanerRuleService = dataCleanerRuleService;
        this.dataCleanerTaskManager = dataCleanerTaskManager;
        this.dataCleaner3dPartyAddonService = dataCleaner3dPartyAddonService;
        this.actonicLicenseService = actonicLicenseService;
        this.configurationManager = configurationManager;
        this.userAccessor = userAccessor;
    }

    public DataCleanerTaskModel createTask(DataCleanerCreateTaskModel createTaskModel, DataCleanerTemplateModel templateModel) throws Exception {
        if (!this.actonicLicenseService.isLicenseValid()) {
            throw new Exception("The license is not valid");
        }
        if (this.dataCleanerTaskDao.hasTaskForTemplate(createTaskModel.getTemplateId())) {
            throw new Exception("Task for this templateId already in queue. You can not create other task");
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            user = this.userAccessor.getUserByName(this.configurationManager.getRunTasksFromUser());
        }
        String username = user != null ? user.getName() : "[system]";
        List<DataCleanerRuleModel> rules = this.dataCleanerRuleService.getEnabledRules(createTaskModel.getTemplateId());
        HashMap<String, String> rulesData = new HashMap<String, String>();
        HashMap<String, String> usersData = new HashMap<String, String>();
        HashMap<String, Integer> otherData = new HashMap<String, Integer>();
        ArrayList<String> sourceUsers = new ArrayList<String>();
        String targetUser = "";
        for (DataCleanerRuleModel rule : rules) {
            rulesData.put(String.valueOf(rule.getId()), rule.getName());
            if (StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleSearchType.USER.getType(), (CharSequence)rule.getSearchType())) {
                sourceUsers.add(rule.getSearchString());
                targetUser = rule.getReplaceString();
                continue;
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)DataCleanerRuleSearchType.ANY_USER.getType(), (CharSequence)rule.getSearchType())) continue;
            sourceUsers.add("any user");
            targetUser = rule.getReplaceString();
        }
        usersData.put("sourceUsers", String.join((CharSequence)", ", sourceUsers));
        usersData.put("targetUser", targetUser);
        otherData.put("numberOfFields", templateModel.getObjects().size());
        otherData.put("numberOfRules", rules.size());
        String taskMetaJson = new Gson().toJson((Object)ImmutableMap.of((Object)"rules", rulesData, (Object)"users", usersData, (Object)"other", otherData));
        DataCleanerTaskEntity entity = this.dataCleanerTaskDao.create(createTaskModel.getTemplateId(), createTaskModel.getType(), username, taskMetaJson);
        entity = this.dataCleanerTaskDao.getById(entity.getID());
        return this.dataCleanerTaskManager.entityToModel(entity);
    }

    public boolean hasTaskForStart() {
        return this.dataCleanerTaskDao.getCurrentInProgressTask() == null && this.dataCleanerTaskDao.getTaskListForStart().size() == 1;
    }

    public Optional<DataCleanerTaskModel> getTaskById(int taskId) {
        DataCleanerTaskEntity dataCleanerTaskEntity = this.dataCleanerTaskDao.getById(taskId);
        return dataCleanerTaskEntity == null ? Optional.empty() : Optional.of(this.dataCleanerTaskManager.entityToModel(dataCleanerTaskEntity));
    }

    public Optional<DataCleanerTaskModel> getActiveTaskForTemplate(int templateId) {
        DataCleanerTaskEntity dataCleanerTaskEntity = this.dataCleanerTaskDao.getActiveTaskForTemplate(templateId);
        Optional<DataCleanerTaskModel> result = dataCleanerTaskEntity == null ? Optional.empty() : Optional.of(this.dataCleanerTaskManager.entityToModel(dataCleanerTaskEntity));
        return result;
    }

    public List<DataCleanerTaskModel> getHistoricalTasksForTemplate(int templateId) {
        List<DataCleanerTaskEntity> dataCleanerTaskEntities = this.dataCleanerTaskDao.getHistoricalTasksForTemplate(templateId);
        List<DataCleanerTaskModel> result = this.dataCleanerTaskManager.entitiesToModels(dataCleanerTaskEntities);
        return result;
    }

    public void cancelTask(int templateId) throws Exception {
        DataCleanerTaskEntity entity = this.dataCleanerTaskDao.getByTemplateId(templateId);
        if (entity == null) {
            throw new Exception("Task with such templateId not found. Nothing cancel.");
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        switch (TaskRequestStatusEnum.getStatus(entity.getStatus())) {
            case NOT_STARTED: 
            case IN_PROGRESS: {
                this.dataCleanerTaskDao.cancel(templateId, "Cancelled by " + user.getFullName() + " (" + user.getName() + ")");
                break;
            }
            default: {
                throw new Exception("Task already finished. You can not cancel this task.");
            }
        }
    }

    public void createScheduledCanceledTask(DataCleanerCreateTaskModel taskModel, DataCleanerTemplateModel template) throws Exception {
        DataCleanerTaskModel model = this.createTask(taskModel, template);
        this.dataCleanerTaskDao.cancel(taskModel.getTemplateId(), "Scheduled task has been canceled because other task already in progress");
    }

    public List<DataCleanerTaskModel> getCurrentTasks() {
        List<DataCleanerTaskEntity> list = this.dataCleanerTaskDao.getTaskListForStart();
        return list.stream().map(entity -> this.dataCleanerTaskManager.entityToModel((DataCleanerTaskEntity)entity)).collect(Collectors.toList());
    }

    public DataCleanerTaskModel getLastTask(Integer templateId) {
        DataCleanerTaskEntity entity = this.dataCleanerTaskDao.getLastTask(templateId);
        if (entity != null) {
            return this.dataCleanerTaskManager.entityToModel(entity);
        }
        return null;
    }

    public void deleteTask(int taskId) {
        this.dataCleaner3dPartyAddonService.deleteHistoryByTaskId(taskId);
        this.dataCleanerTaskDao.delete(taskId);
    }

    public Integer flushInQueueTasks() {
        List<DataCleanerTaskEntity> tasks = this.dataCleanerTaskDao.getTaskListForStart();
        Integer flushSize = tasks.size();
        for (DataCleanerTaskEntity entity : tasks) {
            this.dataCleanerTaskDao.cancelTask(entity.getID(), "Canceled by flush request");
        }
        return flushSize;
    }
}

