/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.confluence.api.model.audit.AffectedObject;
import com.atlassian.confluence.api.model.audit.AuditRecord;
import com.atlassian.confluence.api.model.audit.ChangedValue;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.audit.AuditService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PluginAuditManager {
    private static final String GDPR_CATEGORY_KEY = "de.actonic.confluence.dgpr-tools";
    @ComponentImport
    private final AuditService auditService;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final ConfigurationManager configurationManager;

    @Autowired
    public PluginAuditManager(ConfigurationManager configurationManager, UserAccessor userAccessor, @Qualifier(value="auditService") AuditService auditSessionService) {
        this.configurationManager = configurationManager;
        this.userAccessor = userAccessor;
        this.auditService = auditSessionService;
    }

    public Integer saveAudit(String rowsPerPage, String purgeAccessStatisticsAfter, String runTasksFromUser, String runGdprGroup, boolean trackPageAccessStatistics) {
        ConfluenceUser applicationUser = AuthenticatedUserThreadLocal.get();
        User currentModelUser = new User(null, applicationUser.getName(), applicationUser.getFullName(), applicationUser.getKey());
        ArrayList changedValues = Lists.newArrayList();
        boolean hasModifiedValue = false;
        if (!this.configurationManager.getRowsPerPage().toString().equals(rowsPerPage)) {
            ChangedValue changedRowsPerPage = ChangedValue.builder().name(String.format("'Rows per page' modified from %s to %s", this.configurationManager.getRowsPerPage(), rowsPerPage)).oldValue(this.configurationManager.getRowsPerPage().toString()).newValue(rowsPerPage).build();
            changedValues.add(changedRowsPerPage);
            hasModifiedValue = true;
        }
        if (this.configurationManager.getTrackPageAccessStatistics() != trackPageAccessStatistics) {
            String before = this.configurationManager.getTrackPageAccessStatistics() ? "checked" : "unchecked";
            String after = trackPageAccessStatistics ? "checked" : "unchecked";
            ChangedValue changedTrackPageAccessStatistics = ChangedValue.builder().name(String.format("User switched from %s to %s", before, after)).oldValue(before).newValue(after).build();
            changedValues.add(changedTrackPageAccessStatistics);
            hasModifiedValue = true;
        }
        if (!this.configurationManager.getPurgeAccessStatisticsAfter().toString().equals(purgeAccessStatisticsAfter)) {
            ChangedValue changedPurgeAccessStatisticsAfter = ChangedValue.builder().name(String.format("'Purge Issue access log after' modified from %s to %s", this.configurationManager.getRowsPerPage(), rowsPerPage)).oldValue(this.configurationManager.getPurgeAccessStatisticsAfter().toString()).newValue(purgeAccessStatisticsAfter).build();
            changedValues.add(changedPurgeAccessStatisticsAfter);
            hasModifiedValue = true;
        }
        String oldRunTasksFromUser = this.configurationManager.getRunTasksFromUser();
        ConfluenceUser oldConfluenceUser = null;
        if (oldRunTasksFromUser != null) {
            oldConfluenceUser = this.userAccessor.getUserByKey(new UserKey(this.configurationManager.getRunTasksFromUser()));
            oldRunTasksFromUser = oldConfluenceUser.getName();
        }
        if (oldConfluenceUser != null && !oldRunTasksFromUser.equals(runTasksFromUser)) {
            ChangedValue changedRunTasksFromUser = ChangedValue.builder().name(String.format("'Run all background tasks from user' modified from %s to %s", oldRunTasksFromUser, runTasksFromUser)).oldValue(oldRunTasksFromUser).newValue(runTasksFromUser).build();
            changedValues.add(changedRunTasksFromUser);
            hasModifiedValue = true;
        }
        if (this.configurationManager.getRunGdprGroup() != null && !runGdprGroup.equals(this.configurationManager.getRunGdprGroup())) {
            ChangedValue changedRunGdprGroup = ChangedValue.builder().name(String.format("'GDPR and Security administrators' modified from %s to %s", this.configurationManager.getRunGdprGroup(), runGdprGroup)).oldValue(this.configurationManager.getRunGdprGroup()).newValue(runGdprGroup).build();
            changedValues.add(changedRunGdprGroup);
            hasModifiedValue = true;
        }
        if (hasModifiedValue) {
            AffectedObject affectedObject = AffectedObject.builder().name(String.format("%s", "modified values")).objectType("GDPR and Security for Confluence settings").build();
            AuditRecord record = AuditRecord.builder().createdDate(new DateTime()).remoteAddress("").author(currentModelUser).category(GDPR_CATEGORY_KEY).changedValues((List)changedValues).affectedObject(affectedObject).summary("User switch").build();
            if (this.auditService.storeRecord(record) != null) {
                return record.hashCode();
            }
        }
        return null;
    }
}

