/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.common.datacleaner.rest;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerHistoryModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerResultStatusEnum;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTemplateModel;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerExecuteService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerResultService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTaskService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTemplateService;
import de.actonic.confluence.gdpr.model.ListPaginationModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/data-cleaner-result")
@Produces(value={"application/json"})
public class DataCleanerResultRest {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerResultRest.class);
    private final DataCleanerExecuteService dataCleanerExecuteService;
    private final DataCleanerTaskService dataCleanerTaskService;
    private final DataCleanerResultService dataCleanerResultService;
    private final DataCleanerTemplateService dataCleanerTemplateService;
    private final ConfigurationManager configurationManager;
    private final Gson gson = new Gson();

    public DataCleanerResultRest(DataCleanerExecuteService dataCleanerExecuteService, DataCleanerTaskService dataCleanerTaskService, DataCleanerResultService dataCleanerResultService, DataCleanerTemplateService dataCleanerTemplateService, ConfigurationManager configurationManager) {
        this.dataCleanerExecuteService = dataCleanerExecuteService;
        this.dataCleanerTaskService = dataCleanerTaskService;
        this.dataCleanerResultService = dataCleanerResultService;
        this.dataCleanerTemplateService = dataCleanerTemplateService;
        this.configurationManager = configurationManager;
    }

    @GET
    @Path(value="/{id}")
    public Response getMetaForTemplate(@PathParam(value="id") int templateId) {
        Gson gson = new Gson();
        return Response.ok((Object)gson.toJson((Object)ImmutableMap.of((Object)"activeTask", this.dataCleanerTaskService.getActiveTaskForTemplate(templateId), (Object)"historicalTasks", this.dataCleanerTaskService.getHistoricalTasksForTemplate(templateId)))).build();
    }

    @POST
    @Path(value="/results")
    public Response getTaskResults(@FormParam(value="taskId") int taskId, @FormParam(value="page") int page, @FormParam(value="project") String project, @FormParam(value="object") String object, @FormParam(value="status") String status, @FormParam(value="rule") String rules, @FormParam(value="sortBy") String sortBy) {
        ListPaginationModel listPaginationModel = this.dataCleanerResultService.getFilteredResults(taskId, page, project, object, status, rules, sortBy);
        ImmutableMap resultMap = ImmutableMap.of((Object)"results", (Object)listPaginationModel.getObjList(), (Object)"totalPages", (Object)listPaginationModel.getTotalPages(), (Object)"page", (Object)listPaginationModel.getCurrentPageNum());
        return Response.ok().entity((Object)new Gson().toJson((Object)resultMap)).build();
    }

    @GET
    @Path(value="/projects/{taskId}")
    public Response getProjectMapByTaskId(@PathParam(value="taskId") Integer taskId) {
        Map<String, String> map = this.dataCleanerResultService.getUniqProjectsByTaskId(taskId);
        return Response.ok((Object)new Gson().toJson(map)).build();
    }

    @POST
    @Path(value="/anonymize")
    public Response getTaskResults(@FormParam(value="templateId") Integer templateId, @FormParam(value="itemIds") List<Integer> itemIds) {
        try {
            List<DataCleanerHistoryModel> dataCleanerHistoryModels = this.dataCleanerExecuteService.executeCustomAnonymization(itemIds.get(0));
            return Response.ok().entity((Object)new Gson().toJson(dataCleanerHistoryModels)).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new Gson().toJson((Object)ImmutableMap.of((Object)"errorMsg", (Object)e.getMessage()))).build();
        }
    }

    @POST
    @Path(value="/export")
    @Produces(value={"text/plain"})
    public Response getTaskExport(@FormParam(value="taskId") int taskId, @FormParam(value="project") String project, @FormParam(value="object") String object, @FormParam(value="status") String status, @FormParam(value="rule") String rules, @FormParam(value="sortBy") String sortBy) {
        try {
            ListPaginationModel listPaginationModel;
            Integer pageResults = 5000;
            String fileName = "data-cleaner-" + taskId + "-" + new Date().getTime() + "-export";
            File file = File.createTempFile(fileName, ".csv");
            CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(new String[]{"Space", "Page/Blogpost", "Field", "Affected Content", "Status", "Rule"});
            FileWriter fileWriter = new FileWriter(file);
            CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
            DataCleanerTaskModel task = this.dataCleanerTaskService.getTaskById(taskId).orElse(null);
            if (task == null) {
                return Response.status((int)400).entity((Object)new Gson().toJson((Object)("Cannot find task with such id = " + taskId))).build();
            }
            Map rulesMeta = (Map)task.getMeta().get("rules");
            Integer page = 1;
            do {
                listPaginationModel = this.dataCleanerResultService.getFilteredResults(taskId, page, pageResults, project, object, status, rules, sortBy);
                List histories = listPaginationModel.getObjList();
                for (DataCleanerHistoryModel history : histories) {
                    try {
                        csvFilePrinter.printRecord(new Object[]{history.getSpace().get("name"), history.getCeo().get("title") + " (v." + history.getCeo().get("version") + ")", history.getObject(), history.getData(), DataCleanerResultStatusEnum.getStatus(history.getStatus()).toString(), rulesMeta.get("" + history.getRuleId())});
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Integer n = page;
                Integer n2 = page = Integer.valueOf(page + 1);
            } while (listPaginationModel.getCurrentPageNum() <= listPaginationModel.getTotalPages());
            fileWriter.flush();
            fileWriter.close();
            csvFilePrinter.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=" + fileName + ".csv"));
            return response.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.ok().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/export/all")
    @Produces(value={"text/plain"})
    public Response getExportForLatestTemplateTask() {
        try {
            Integer pageResults = 5000;
            String fileName = "data-cleaner-whole-" + new Date().getTime() + "-export";
            File file = File.createTempFile(fileName, ".csv");
            CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(new String[]{"Template Name", "Space", "Page/Blogpost", "Field", "Affected Content", "Status", "Rule"});
            FileWriter fileWriter = new FileWriter(file);
            CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
            List<DataCleanerTemplateModel> allTemplates = this.dataCleanerTemplateService.getAllTemplates();
            for (DataCleanerTemplateModel template : allTemplates) {
                ListPaginationModel listPaginationModel;
                Integer taskId;
                DataCleanerTaskModel task;
                DataCleanerTaskModel lastTask = this.dataCleanerTaskService.getLastTask(template.getId());
                if (lastTask == null || (task = (DataCleanerTaskModel)this.dataCleanerTaskService.getTaskById(taskId = Integer.valueOf(lastTask.getId())).orElse(null)) == null) continue;
                Map rulesMeta = (Map)task.getMeta().get("rules");
                Integer page = 1;
                do {
                    listPaginationModel = this.dataCleanerResultService.getFilteredResults(taskId, page, pageResults, null, null, null, null, "0");
                    List histories = listPaginationModel.getObjList();
                    for (DataCleanerHistoryModel history : histories) {
                        try {
                            csvFilePrinter.printRecord(new Object[]{template.getName(), history.getSpace().get("name"), history.getCeo().get("title") + " (v." + history.getCeo().get("version") + ")", history.getObject(), history.getData(), DataCleanerResultStatusEnum.getStatus(history.getStatus()).toString(), rulesMeta.get("" + history.getRuleId())});
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    Integer n = page;
                    Integer n2 = page = Integer.valueOf(page + 1);
                } while (listPaginationModel.getCurrentPageNum() <= listPaginationModel.getTotalPages());
            }
            fileWriter.flush();
            fileWriter.close();
            csvFilePrinter.close();
            Response.ResponseBuilder response = Response.ok((Object)file);
            response.header("Content-Disposition", (Object)("attachment; filename=" + fileName + ".csv"));
            return response.build();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Response.ok().entity((Object)new Gson().toJson((Object)e.getMessage())).build();
        }
    }
}

