/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.upgrade.v4;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.google.common.collect.Sets;
import de.actonic.gdpr.announcement.ao.AnnouncementEntity;
import de.actonic.gdpr.announcement.ao.AnnouncementHistoryEntity;
import de.actonic.gdpr.shared.general.model.GDPRVersionType;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRNamingUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask004
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask004.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"4");
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        int count;
        activeObjects.migrate(new Class[]{AnnouncementEntity.class, AnnouncementHistoryEntity.class});
        log.info("UPGRADE TASK 004 STARTED");
        log.info("Start updating 'Announcement' entities");
        try {
            count = 0;
            AnnouncementEntity[] announcingEntities = (AnnouncementEntity[])activeObjects.find(AnnouncementEntity.class);
            ArrayList entityNames = new ArrayList();
            AnnouncementEntity[] announcementEntityArray = announcingEntities;
            int n = announcementEntityArray.length;
            for (int i = 0; i < n; ++i) {
                AnnouncementEntity entity = announcementEntityArray[i];
                if (entity.getVersion() != null) continue;
                log.info("Entity name is already exist: " + GDPRNamingUtils.isContains((String)entity.getName(), entityNames));
                entity.setVersion(1);
                entity.setAnnouncementType(GDPRVersionType.CURRENT.getType());
                entity.setContributors(GDPRJsonUtils.toJson((Object)Sets.newHashSet((Object[])new String[]{entity.getCreator()})));
                this.setAnnouncementStyle(entity);
                this.setIsShowInPeriod(entity);
                String newName = GDPRNamingUtils.generateUniqueName((String)entity.getName(), entityNames);
                entity.setName(newName);
                entity.save();
                log.info("Final entity name: " + newName);
                log.info(String.format("entity %d of %d, result: %s", ++count, announcingEntities.length, "success"));
            }
            log.info("Announcement entities updated.");
        }
        catch (Exception e) {
            log.info("Announcement entities failed. Error: " + e.getLocalizedMessage());
        }
        log.info("Start updating 'AnnouncementHistory' entities");
        try {
            AnnouncementHistoryEntity[] announcingHistoryEntities;
            count = 0;
            for (AnnouncementHistoryEntity entity : announcingHistoryEntities = (AnnouncementHistoryEntity[])activeObjects.find(AnnouncementHistoryEntity.class)) {
                if (entity.getVersion() != null) continue;
                entity.setVersion(1);
                entity.save();
                log.info(String.format("entity %d of %d, result: %s", ++count, announcingHistoryEntities.length, "success"));
            }
            log.info("AnnouncementHistory entities updated.");
        }
        catch (Exception e) {
            log.info("AnnouncementHistory entities failed. Error: " + e.getLocalizedMessage());
        }
        log.info("UPGRADE TASK 004 FINISHED");
    }

    private void setAnnouncementStyle(AnnouncementEntity entity) {
        if (entity.getIsPinned()) {
            if ("none".equals(entity.getStyle())) {
                entity.setStyle("pin");
            }
            if ("center".equals(entity.getStyle())) {
                entity.setStyle("pin-center");
            }
            if ("bottom".equals(entity.getStyle())) {
                entity.setStyle("pin-bottom");
            }
            if ("block-login-form".equals(entity.getStyle())) {
                entity.setStyle("pin-block-login-form");
            }
        }
        if (!entity.getIsPinned()) {
            if ("center".equals(entity.getStyle())) {
                entity.setStyle("center");
            }
            if ("bottom".equals(entity.getStyle())) {
                entity.setStyle("bottom");
            }
            if ("block-login-form".equals(entity.getStyle())) {
                entity.setStyle("block-login-form");
            }
        }
    }

    private void setIsShowInPeriod(AnnouncementEntity entity) {
        if (entity.getStartDate() != null || entity.getEndDate() != null) {
            entity.setIsShowInPeriod(true);
        }
    }
}

