/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service.changer;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.changer.Changer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BodyContentChanger
implements Changer {
    private static final Logger log = LoggerFactory.getLogger(BodyContentChanger.class);
    private final PageManager pageManager;
    private final ContentEntityObjectDao contentEntityObjectDao;
    private final TransactionTemplate transactionTemplate;
    private final DraftsTransitionHelper draftsTransitionHelper;
    private final SaveContext SAVE_CONTEXT = ((DefaultSaveContext.Builder)((DefaultSaveContext.Builder)DefaultSaveContext.builder().suppressAutowatch(true).suppressNotifications(true)).suppressEvents(true)).updateLastModifier(false).build();

    @Autowired
    public BodyContentChanger(@ComponentImport PageManager pageManager, @ComponentImport ContentEntityObjectDao contentEntityObjectDao, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport DraftsTransitionHelper draftsTransitionHelper) {
        this.pageManager = pageManager;
        this.contentEntityObjectDao = contentEntityObjectDao;
        this.transactionTemplate = transactionTemplate;
        this.draftsTransitionHelper = draftsTransitionHelper;
    }

    @Override
    public String getType() {
        return "text";
    }

    @Override
    public List<String> extractValues(Long ceoId) {
        return (List)this.transactionTemplate.execute(() -> {
            ContentEntityObject contentEntityObject = this.pageManager.getById(ceoId.longValue());
            return contentEntityObject == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new String[]{contentEntityObject.getBodyAsString()});
        });
    }

    @Override
    public void applyNewValues(Long ceoId, Map<String, String> oldNewValuesMap) {
        this.transactionTemplate.execute(() -> {
            ContentEntityObject tCeo = this.pageManager.getById(ceoId.longValue());
            for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                String bodyContent = tCeo.getBodyAsString();
                if (!bodyContent.contains((CharSequence)entry.getKey())) continue;
                tCeo.setBodyAsString(bodyContent.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue()));
            }
            this.pageManager.saveContentEntity(tCeo, this.SAVE_CONTEXT);
            ContentEntityObject draft = this.draftsTransitionHelper.getDraftForPage((AbstractPage)tCeo);
            if (draft != null) {
                for (Map.Entry entry : oldNewValuesMap.entrySet()) {
                    String bodyContent = draft.getBodyAsString();
                    if (!bodyContent.contains((CharSequence)entry.getKey())) continue;
                    draft.setBodyAsString(bodyContent.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue()));
                }
                this.pageManager.saveContentEntity(draft, this.SAVE_CONTEXT);
            }
            return true;
        });
    }

    protected List<ContentEntityObject> getVersionList(ContentEntityObject versionPage) {
        ArrayList versions = Lists.newArrayList();
        versions.add(versionPage);
        while ((versionPage = this.pageManager.getPreviousVersion(versionPage)) != null) {
            versions.add(versionPage);
        }
        return versions;
    }
}

