/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerCreateTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerScheduleModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTemplateModel;
import de.actonic.confluence.gdpr.common.datacleaner.model.TaskRequestStatusEnum;
import de.actonic.confluence.gdpr.component.manager.CronManager;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTaskEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerSchedulerManager;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTaskService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerTemplateService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerSchedulerService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerSchedulerService.class);
    private final DataCleanerSchedulerManager dataCleanerSchedulerManager;
    private final DataCleanerTaskService dataCleanerTaskService;
    private final DataCleanerTemplateService dataCleanerTemplateService;
    private final CronManager cronExpressionsManager;
    private final DataCleanerSchedulerManager schedulerManager;
    private final DataCleanerTaskDao dataCleanerTaskDao;
    private final PluginSettings pluginSettings;

    @Autowired
    public DataCleanerSchedulerService(DataCleanerSchedulerManager dataCleanerSchedulerManager, DataCleanerTaskService dataCleanerTaskService, DataCleanerTemplateService dataCleanerTemplateService, CronManager cronExpressionsManager, DataCleanerSchedulerManager schedulerManager, DataCleanerTaskDao dataCleanerTaskDao, @ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.dataCleanerSchedulerManager = dataCleanerSchedulerManager;
        this.dataCleanerTaskService = dataCleanerTaskService;
        this.dataCleanerTemplateService = dataCleanerTemplateService;
        this.cronExpressionsManager = cronExpressionsManager;
        this.schedulerManager = schedulerManager;
        this.dataCleanerTaskDao = dataCleanerTaskDao;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr.datacleaner.last-run");
    }

    public DataCleanerTaskModel getOrCreateNextCronTask() {
        log.debug("> getOrCreateNextCronTask");
        DataCleanerTaskModel newTask = null;
        List<DataCleanerScheduleModel> activeTasks = this.dataCleanerSchedulerManager.getActiveScheduledTasks();
        for (DataCleanerScheduleModel task : activeTasks) {
            log.debug("> checking task for templateId=" + task.getTemplateId());
            Long lastExecutionByCron = this.cronExpressionsManager.getLastExecutionInMillis(task.getCron());
            Object lastExecutionObject = this.pluginSettings.get("template-" + task.getTemplateId());
            if (lastExecutionObject == null) {
                this.pluginSettings.put("template-" + task.getTemplateId(), (Object)("" + new Date().getTime()));
                continue;
            }
            Long lastExecutionByTask = Long.parseLong((String)lastExecutionObject);
            log.debug(">> lastExecutionByCron=" + new Date(lastExecutionByCron));
            log.debug(">> lastExecutionByTask=" + new Date(lastExecutionByTask));
            log.debug(">>> shouldStartTask?=" + (lastExecutionByCron > lastExecutionByTask));
            if (!this.cronExpressionsManager.isExecutionTimeComes(lastExecutionByCron, lastExecutionByTask)) continue;
            log.debug(">> hasNewTask=" + (newTask != null) + (newTask != null ? ", cancelling this task" : ", creating task for execution"));
            try {
                this.pluginSettings.put("template-" + task.getTemplateId(), (Object)("" + new Date().getTime()));
                DataCleanerTemplateModel template = this.dataCleanerTemplateService.getTemplate(task.getTemplateId());
                if (newTask == null) {
                    if (this.switchOffScheduler(task)) continue;
                    newTask = this.dataCleanerTaskService.createTask(DataCleanerCreateTaskModel.builder().templateId(template.getId()).templateType(template.getTemplateType()).type(task.getTaskType()).build(), template);
                    continue;
                }
                this.dataCleanerTaskService.createScheduledCanceledTask(DataCleanerCreateTaskModel.builder().templateId(task.getTemplateId()).templateType(template.getTemplateType()).type(task.getTaskType()).build(), template);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.debug("> result=" + newTask);
        return newTask;
    }

    private boolean switchOffScheduler(DataCleanerScheduleModel task) {
        List<DataCleanerTaskEntity> taskList = this.dataCleanerTaskDao.getHistoricalTasksForTemplate(task.getTemplateId());
        if (this.hasDefinedFailedTasks(taskList, 3)) {
            List<DataCleanerScheduleModel> cronsForTemplate = this.dataCleanerSchedulerManager.getCronsForTemplate(task.getTemplateId());
            for (DataCleanerScheduleModel entity : cronsForTemplate) {
                entity.setEnabled(false);
                this.dataCleanerSchedulerManager.updateCron(entity.getId(), entity);
            }
            return true;
        }
        return false;
    }

    private boolean hasDefinedFailedTasks(List tasks, Integer numberFailedTasks) {
        if (tasks.size() < numberFailedTasks) {
            return false;
        }
        Integer counter = 0;
        List lastElements = tasks.subList(tasks.size() - numberFailedTasks, tasks.size());
        for (DataCleanerTaskEntity entity : lastElements) {
            if (entity.getStatus() != TaskRequestStatusEnum.ABORTED.getCode() && entity.getStatus() != TaskRequestStatusEnum.FAILED.getCode()) continue;
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        }
        return counter >= numberFailedTasks;
    }
}

