define("actonic-gdpr/core/wait-for-element", ["actonic-gdpr/core/safe-jquery"], function ($) {

    function WaitForElement() {
        var maxWaitCount = 100; // 10 sec max

        this.waitFor = function (selector, successCallback) {
            var currentWaitCount = 0;
            var existCondition = setInterval(function() {
                if (currentWaitCount > maxWaitCount) {
                    clearInterval(existCondition);
                    //console.log("can not find element '" + selector + "'");
                }
                if ($(selector).length) {
                    clearInterval(existCondition);
                    if (typeof successCallback === "function") successCallback();
                }
                currentWaitCount++;
            }, 100); // check every 100ms
        };

        this.waitForIframe = function(selector, successCallback) {
            var iframe;
            var doc;
            var existCondition = setInterval(function(){
                iframe = document.getElementById(selector);

                if(iframe) {
                    if (iframe.contentDocument) // FireFox, Chrome
                        doc = iframe.contentDocument;
                    else if ( iframe.contentWindow ) // IE
                        doc = iframe.contentWindow.document;

                    if (  doc.readyState  == 'complete' ) {
                        clearInterval(existCondition);
                        if (typeof successCallback === "function") successCallback();
                    }
                }
            }, 100);
        };
    }

    return new WaitForElement();
});
