require(
    ["jquery", "actonic-gdpr/profile-visibility/rest", "actonic-gdpr/core/flags", "actonic-gdpr/domReady", "actonic-gdpr/announcing/rest"],
    function ($, Rest, flags, domReady, announcementRest) {
        domReady(function () {
            new ConfigurationModule().init();
        });

        var isAllowConfigOwnProfile = false;

        function ConfigurationModule() {
            this.init = function() {
                $("#profile-visibility-settings-edit-button").click(function () {
                    if(isAllowConfigOwnProfile) {
                        AJS.dialog2("#profile-visibility-edit-dialog").show();
                    }
                });
                $("#profile-visibility-edit-dialog-ok-button").click(function () {
                    if ($("#hide-for-all-checkbox").prop("checked")) {
                        Rest.hideMyProfileForAll(
                            function () {
                                $("#profile-visibility-hide-from-everyone").text(AJS.I18n.getText("js-profile-visibility.panel.app.hide-from-everyone.yes"));
                                flags.simpleSuccess(AJS.I18n.getText("js-profile-visibility.panel.app.hide-from-everyone.changed"));
                            },
                            function (error) {
                                log.error("Rest.hideMyProfileForAll error = " + JSON.stringify(error));
                            }
                        )
                    } else {
                        Rest.showMyProfileForAll(
                            function () {
                                $("#profile-visibility-hide-from-everyone").text(AJS.I18n.getText("js-profile-visibility.panel.app.hide-from-everyone.no"));
                                flags.simpleSuccess(AJS.I18n.getText("js-profile-visibility.panel.app.hide-from-everyone.changed"));
                            },
                            function (error) {
                                log.error("Rest.showMyProfileForAll error = " + JSON.stringify(error));
                            }
                        )
                    }
                    AJS.dialog2("#profile-visibility-edit-dialog").hide();
                });
                $("#profile-visibility-edit-dialog-close-button").click(function () {
                    AJS.dialog2("#profile-visibility-edit-dialog").hide();
                });

                getProfileVisibilitySettings();
                getAnnouncementsByUser();
            };

            function getProfileVisibilitySettings() {
                Rest.getMyProfileVisibilitySettings(
                    function (data) {
                        if(data && data.configOwnProfile.allowConfigOwnProfile) {
                            isAllowConfigOwnProfile = true;
                            $("#visibility-change").show();
                        }
                        if (data && data.configOwnProfile.allowConfigOwnProfile && data.configOwnProfile.hideFromEveryone) {
                            $("#profile-visibility-hide-from-everyone").text(AJS.I18n.getText("js-profile-visibility.panel.app.hide-from-everyone.yes"));
                            $("#hide-for-all-checkbox").prop("checked","checked");
                        } else {
                            $("#profile-visibility-hide-from-everyone").text(AJS.I18n.getText("js-profile-visibility.panel.app.hide-from-everyone.no"));
                            $("#hide-for-all-checkbox").prop("checked",false);
                        }
                    },
                    function (error) {
                        log.error("Rest.getMyProfileVisibilitySettings error = " + JSON.stringify(error));
                    }
                )
            }

            function getAnnouncementsByUser() {
                Rest.getAnnouncingByUser(
                    function (announcingItems) {
                        if (announcingItems) {
                            announcingItems.forEach(function (announcingItem) {
                                displayAnnouncingByUser(announcingItem);
                            });

                            $(".announcing-row").off("click");
                            $(".announcing-row").on("click", function (event) {
                                var dataRowId = $(this).attr("data-row-id");
                                announcingItems.forEach(function (announcingItem) {
                                    if (announcingItem.id == dataRowId) {
                                        announcementRest.getAnnouncingBody(announcingItem.id, function (data) {
                                            announcingItem.body = data;
                                            if (!announcingItem.style || announcingItem.style === "center") {
                                                renderAnnouncingDialog(announcingItem);
                                            } else if (announcingItem.style === "bottom") {
                                                renderAnnouncingBottom(announcingItem);
                                            }
                                        })
                                    }
                                });
                            });
                        }
                    },
                    function (error) {
                        log.error("Rest.getMyProfileVisibilitySettings error = " + JSON.stringify(error));
                    }
                )
            }

            function renderAnnouncingDialog(announcing) {
                var windowSize = announcing.windowSize ? announcing.windowSize : "medium";
                var dialog = ACTONIC.GDPR.GLOBAL.getAnnouncingDialog({
                    id: announcing.id,
                    title: announcing.title,
                    type: announcing.type,
                    method: "render",
                    windowSize: windowSize,
                    accept: announcing.accept ? announcing.accept : AJS.I18n.getText("soy-global.accept"),
                    decline: announcing.decline ? announcing.decline : AJS.I18n.getText("soy-global.decline"),
                    action: "regular",
                    announcingbody: announcing.body,
                    questionnaire: announcing.questionnaire,
                    response: announcing.extraFields.response
                });

                // log.debug("dialog = " + dialog);
                $("body").append(dialog);
                AJS.dialog2("#announcing-dialog-" + announcing.id).show();
                $("#announcing-dialog-" + announcing.id + "-accept-btn").off("click");
                $("#announcing-dialog-" + announcing.id + "-accept-btn").on("click", function () {
                    //log.debug("accept-btn click");
                    var request = {questionnaire: $("#questionnaire").val()};
                    Rest.updateAnswer(announcing.id, "accepted", request,
                        function () { // success
                            //log.debug("Rest.getAnnouncingForUser success");
                            AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
                            flags.simpleSuccess(AJS.I18n.getText("js-global-display-announcing-accept-announcing-flag-done-body"));
                            var newCell = ACTONIC.GDPR.USERPROFILE.createAnnouncingTableCell({
                                status: "accepted"
                            });
                            $("#announcing-table td[data-row-id=" + announcing.id + "]>span.inner-cell").replaceWith(newCell);
                        },
                        function (error) { // error
                            log.error("Rest.acceptAnnouncing error = " + JSON.stringify(error));
                            AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
                            flags.showFlag("Error", JSON.stringify(error), "warning");
                        });
                });
                $("#announcing-dialog-" + announcing.id + "-decline-btn").off("click");
                $("#announcing-dialog-" + announcing.id + "-decline-btn").on("click", function () {
                    var request = {questionnaire: $("#questionnaire").val()};
                    //log.debug("cancel-btn click");
                    Rest.updateAnswer(announcing.id, "declined", request,
                        function () { // success
                            AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
                            flags.simpleSuccess(AJS.I18n.getText("js-global-display-announcing-decline-announcing-flag-done-body"));
                            var newCell = ACTONIC.GDPR.USERPROFILE.createAnnouncingTableCell({
                                status: "declined"
                            });
                            $("#announcing-table td[data-row-id=" + announcing.id + "]>span.inner-cell").replaceWith(newCell);
                        },
                        function (error) { // error
                            log.error("Rest.declineAnnouncing error = " + JSON.stringify(error));
                            AJS.dialog2("#announcing-dialog-" + announcing.id).hide();
                            flags.showFlag("Error", JSON.stringify(error), "warning");
                        });
                });
            }

            function renderAnnouncingBottom(announcing) {
                var windowSize = announcing.windowSize ? announcing.windowSize : "medium";
                var winNumericSize = getWinNumericaSize(windowSize);
                var bottom = ACTONIC.GDPR.GLOBAL.getAnnouncingBottom({
                    id: announcing.id,
                    title: announcing.title,
                    type: announcing.type,
                    windowSize: winNumericSize,
                    accept: announcing.accept ? announcing.accept : AJS.I18n.getText("soy-global.accept"),
                    decline: announcing.decline ? announcing.decline : AJS.I18n.getText("soy-global.decline"),
                    action: "regular",
                    announcingbody: announcing.body,
                    questionnaire: announcing.questionnaire,
                    response: announcing.extraFields.response
                });

                //log.debug("dialog = " + bottom);

                $("body").append(bottom);
                $("#announcing-bottom-" + announcing.id).show();
                $("#announcing-bottom-" + announcing.id + "-accept-btn").off("click");
                $("#announcing-bottom-" + announcing.id + "-accept-btn").on("click", function () {
                    var request = {questionnaire: $("#questionnaire").val()};
                    Rest.updateAnswer(announcing.id, "accepted", request,
                        function () { // success
                            //log.debug("Rest.getAnnouncingForUser success");
                            $("#announcing-bottom-" + announcing.id).remove();
                            $(".aui-blanket").hide();
                            flags.simpleSuccess(AJS.I18n.getText("js-global-display-announcing-accept-announcing-flag-done-body"));
                            var newCell = ACTONIC.GDPR.USERPROFILE.createAnnouncingTableCell({
                                status: "accepted"
                            });
                            $("#announcing-table td[data-row-id=" + announcing.id + "]>span.inner-cell").replaceWith(newCell);
                        },
                        function (error) { // error
                            log.error("Rest.acceptAnnouncing error = " + JSON.stringify(error));
                            $("#announcing-bottom-" + announcing.id).remove();
                            flags.showFlag("Error", JSON.stringify(error), "warning");
                        });
                });
                $("#announcing-bottom-" + announcing.id + "-decline-btn").off("click");
                $("#announcing-bottom-" + announcing.id + "-decline-btn").on("click", function () {
                    var request = {questionnaire: $("#questionnaire").val()};
                    Rest.updateAnswer(announcing.id, "declined", request,
                        function () { // success
                            $("#announcing-bottom-" + announcing.id).remove();
                            $(".aui-blanket").hide();
                            flags.simpleSuccess(AJS.I18n.getText("js-global-display-announcing-decline-announcing-flag-done-body"));
                            var newCell = ACTONIC.GDPR.USERPROFILE.createAnnouncingTableCell({
                                status: "declined"
                            });
                            $("#announcing-table td[data-row-id=" + announcing.id + "]>span.inner-cell").replaceWith(newCell);
                        },
                        function (error) { // error
                            log.error("Rest.declineAnnouncing error = " + JSON.stringify(error));
                            $("#announcing-bottom-" + announcing.id).remove();
                            flags.showFlag("Error", JSON.stringify(error), "warning");
                        });
                });
            }

            function getWinNumericaSize(windowSize) {
                if(windowSize == "small") return 30;
                else if(windowSize == "medium") return 50;
                else if(windowSize == "large") return 70;
                else if(windowSize == "xlarge") return 90;
            }

            function displayAnnouncingByUser(announcingItem) {
                var row = ACTONIC.GDPR.USERPROFILE.createAnnouncingTableRow({
                    id: announcingItem.id,
                    title: announcingItem.title,
                    status: announcingItem.extraFields.status
                });
                $("#announcing-table tbody").append(row);
            }

        }
    });
