/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.newDC.rest.template;

import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import de.actonic.gdpr.shared.newDC.model.template.ActionDCModel;
import de.actonic.gdpr.shared.newDC.service.template.action.ActionDCService;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/templates/{templateId}/actions")
@Produces(value={"application/json"})
public class ActionDCRest {
    private static final Logger log = LoggerFactory.getLogger(ActionDCRest.class);
    private final ActionDCService actionService;

    public ActionDCRest(ActionDCService actionService) {
        this.actionService = actionService;
    }

    @GET
    @Path(value="/")
    public Response getTemplateActions(@PathParam(value="templateId") Integer templateId) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List actions = this.actionService.getTemplateActions(templateId);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)actions)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/{actionId}")
    public Response getTemplateActionById(@PathParam(value="templateId") Integer templateId, @PathParam(value="actionId") String actionId) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            ActionDCModel action = this.actionService.getTemplateActionById(templateId, actionId);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)action)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/")
    public Response createTemplateAction(@PathParam(value="templateId") Integer templateId, @RequestBody ActionDCModel requestModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            List actions = this.actionService.addTemplateAction(templateId, requestModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)actions)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/{actionId}")
    public Response updateTemplateActionById(@PathParam(value="templateId") Integer templateId, @PathParam(value="actionId") String actionId, @RequestBody ActionDCModel requestModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            requestModel.setId(actionId);
            List actions = this.actionService.updateTemplateActionById(templateId, requestModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)actions)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="/{actionId}")
    public Response deleteTemplateActionById(@PathParam(value="templateId") Integer templateId, @PathParam(value="actionId") String actionId) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            this.actionService.deleteActionById(templateId, actionId);
            log.debug(logHelper.stop());
            return Response.ok().build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

