/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.current.datacleaner.component.service;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.actonic.confluence.gdpr.common.datacleaner.model.DataCleanerTaskModel;
import de.actonic.confluence.gdpr.component.manager.ConfigurationManager;
import de.actonic.confluence.gdpr.current.datacleaner.ao.DataCleanerTaskEntity;
import de.actonic.confluence.gdpr.current.datacleaner.component.manager.DataCleanerTaskDao;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleaner3dPartyAddonService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerExecuteService;
import de.actonic.confluence.gdpr.current.datacleaner.component.service.DataCleanerSchedulerService;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCleanerTaskExecutionService {
    private static final Logger log = LoggerFactory.getLogger(DataCleanerTaskExecutionService.class);
    private final DataCleaner3dPartyAddonService dataCleaner3dPartyAddonService;
    private final DataCleanerExecuteService dataCleanerExecuteService;
    private final DataCleanerTaskDao dataCleanerTaskDao;
    private final DataCleanerSchedulerService dataCleanerSchedulerService;
    private final ConfigurationManager configurationManager;
    @ComponentImport
    private SchedulerService schedulerService;
    private static final String DATA_CLEANER_JOB_KEY = "actonic-gdpr-data-cleaner-job-runner";
    private static final long MINUTES_TIMEOUT = 60000L;

    @Autowired
    public DataCleanerTaskExecutionService(DataCleaner3dPartyAddonService dataCleaner3dPartyAddonService, DataCleanerExecuteService dataCleanerExecuteService, DataCleanerTaskDao dataCleanerTaskDao, DataCleanerSchedulerService dataCleanerSchedulerService, ConfigurationManager configurationManager, SchedulerService schedulerService) {
        this.dataCleaner3dPartyAddonService = dataCleaner3dPartyAddonService;
        this.dataCleanerExecuteService = dataCleanerExecuteService;
        this.dataCleanerTaskDao = dataCleanerTaskDao;
        this.dataCleanerSchedulerService = dataCleanerSchedulerService;
        this.configurationManager = configurationManager;
        this.schedulerService = schedulerService;
    }

    public void executeIfExists() {
        Integer templateIdTmp;
        this.dataCleaner3dPartyAddonService.validateEntitiesForTimeout();
        DataCleanerTaskEntity task = this.dataCleanerTaskDao.getCurrentInProgressTask();
        Integer timeout = this.configurationManager.getTaskTimeout();
        if (task != null) {
            if (task.getLastUpdateTime() == null) {
                this.dataCleanerTaskDao.setLastUpdateTime(task.getID(), System.currentTimeMillis());
            }
            if (System.currentTimeMillis() - task.getLastUpdateTime() > 60000L * (long)timeout.intValue()) {
                this.dataCleanerTaskDao.cancelTask(task.getID(), "Cancelled by timeout");
            }
        }
        if (task != null) {
            return;
        }
        DataCleanerTaskEntity entity = this.dataCleanerTaskDao.getNextTaskForStart();
        if (entity == null) {
            DataCleanerTaskModel model = this.dataCleanerSchedulerService.getOrCreateNextCronTask();
            if (model == null) {
                return;
            }
            templateIdTmp = model.getTemplateId();
        } else {
            templateIdTmp = entity.getTemplateId();
        }
        final Integer templateId = templateIdTmp;
        JobRunnerKey runnerKey = JobRunnerKey.of((String)DATA_CLEANER_JOB_KEY);
        this.schedulerService.registerJobRunner(runnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
                DataCleanerTaskExecutionService.this.dataCleanerExecuteService.execute(templateId);
                return JobRunnerResponse.success();
            }
        });
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)runnerKey).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce(null));
        try {
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig).toString();
        }
        catch (SchedulerServiceException sse) {
            this.dataCleanerTaskDao.cancel(task.getTemplateId(), sse.getMessage());
            throw new SchedulerRuntimeException(sse.getMessage(), (Throwable)sse);
        }
    }

    public DataCleanerTaskModel getCurrentStatus() {
        return this.dataCleanerExecuteService.status();
    }
}

