/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service.anonymizer.content;

import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.BasicContentChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WatcherChanger
extends BasicContentChanger {
    public static final String NAME = "removeFromWatchers";
    @ComponentImport
    private NotificationManager notificationManager;
    @ComponentImport
    private TransactionTemplate transactionTemplate;

    @Autowired
    public WatcherChanger(@ComponentImport PluginSettingsFactory pluginSettingsFactory, NotificationManager notificationManager, TransactionTemplate transactionTemplate) {
        super(pluginSettingsFactory, transactionTemplate);
        this.notificationManager = notificationManager;
    }

    @Override
    public String getAffectedContent(EntityObject issue, ConfluenceUser user) {
        String affectedContent = "";
        List notifications = this.notificationManager.getNotificationsByUser((User)user);
        for (Notification notification : notifications) {
            if (notification.getContent() != null) {
                affectedContent = affectedContent + notification.getContent().getId() + ", ";
                continue;
            }
            if (notification.getSpace() == null) continue;
            affectedContent = affectedContent + notification.getSpace().getKey() + ", ";
        }
        return affectedContent;
    }

    @Override
    public boolean isAffected(EntityObject issue, ConfluenceUser user) {
        return this.notificationManager.getNotificationsByUser((User)user).size() > 0;
    }

    @Override
    public ContentChangerResult changeIssues(String currentJobId, EntityObject issue, ConfluenceUser sourceUser, ConfluenceUser targetUser) {
        this.setJobMessage(currentJobId, "Removing user from all notifications...");
        String changesTotal = "";
        String changesSuccess = "";
        String changesFail = "";
        List notifications = this.notificationManager.getNotificationsByUser((User)sourceUser);
        if (this.isAffected(issue, sourceUser)) {
            changesTotal = changesTotal + notifications.size();
            try {
                int size = notifications.size();
                this.notificationManager.removeAllNotificationsForUser((User)sourceUser);
                changesSuccess = changesSuccess + "removed " + size + " watch pages, ";
            }
            catch (Exception e) {
                changesFail = changesFail + "failed:" + notifications.size() + " steel alive";
            }
        }
        return new ContentChangerResult(this.getChangerName(), changesTotal, changesSuccess, changesFail);
    }

    @Override
    public String getChangerName() {
        return NAME;
    }
}

