/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.ao.AnnouncingEntity;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncingDao
extends AbstractEntityDao {
    @Autowired
    public AnnouncingDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public AnnouncingEntity getById(int id) {
        AnnouncingEntity entity = this.getFirstByField(AnnouncingEntity.class, "ID", id);
        return entity;
    }

    public AnnouncingEntity createEntity(boolean isActive, Date startDate, Date endDate, String name, String type, String style, String creator, Date creationDate, Date modificationDate, String lastModifier, String group, boolean isQuestionnaire, boolean isAnonymous, String windowSize, String accept, String decline, boolean isPinned, String title, String content, Long pageId, String body) {
        AnnouncingEntity entity = (AnnouncingEntity)this.ao.create(AnnouncingEntity.class, new DBParam[0]);
        entity.setIsActive(isActive);
        entity.setStartDate(startDate);
        entity.setEndDate(endDate);
        entity.setName(name);
        entity.setType(type);
        entity.setStyle(style);
        entity.setCreator(creator);
        entity.setCreationDate(creationDate);
        entity.setModificationDate(modificationDate);
        entity.setLastModifier(lastModifier);
        entity.setGroup(group);
        entity.setIsQuestionnaire(isQuestionnaire);
        entity.setIsAnonymous(isAnonymous);
        entity.setWindowSize(windowSize);
        entity.setAccept(accept);
        entity.setDecline(decline);
        entity.setIsPinned(isPinned);
        entity.setTitle(title);
        entity.setContent(content);
        entity.setPageId(pageId);
        entity.setBody(body);
        entity.save();
        return entity;
    }

    public AnnouncingEntity updateEntity(int id, boolean isActive, Date startDate, Date endDate, String name, String type, String style, Date modificationDate, String lastModifier, String group, boolean isQuestionnaire, boolean isAnonymous, String windowSize, String accept, String decline, boolean isPinned, String title, String content, Long pageId, String body) {
        AnnouncingEntity entity = this.getFirstByField(AnnouncingEntity.class, "ID", id);
        entity.setIsActive(isActive);
        entity.setStartDate(startDate);
        entity.setEndDate(endDate);
        entity.setName(name);
        entity.setType(type);
        entity.setStyle(style);
        entity.setModificationDate(modificationDate);
        entity.setLastModifier(lastModifier);
        entity.setGroup(group);
        entity.setIsQuestionnaire(isQuestionnaire);
        entity.setIsAnonymous(isAnonymous);
        entity.setWindowSize(windowSize);
        entity.setAccept(accept);
        entity.setDecline(decline);
        entity.setIsPinned(isPinned);
        entity.setTitle(title);
        entity.setContent(content);
        entity.setPageId(pageId);
        entity.setBody(body);
        entity.save();
        return entity;
    }

    public AnnouncingEntity updateStatus(int id, boolean isActive) {
        AnnouncingEntity entity = this.getFirstByField(AnnouncingEntity.class, "ID", id);
        entity.setIsActive(isActive);
        entity.save();
        return entity;
    }

    public void deleteEntity(int id) {
        AnnouncingEntity entity = this.getFirstByField(AnnouncingEntity.class, "ID", id);
        this.ao.delete(new RawEntity[]{entity});
    }

    public List<AnnouncingEntity> getAllEntities() {
        Object[] entities = (AnnouncingEntity[])this.ao.find(AnnouncingEntity.class, Query.select().order("ID ASC"));
        return Lists.newArrayList((Object[])entities);
    }

    public List<AnnouncingEntity> getActiveEntities() {
        Date now = new Date();
        Object[] entities = (AnnouncingEntity[])this.ao.find(AnnouncingEntity.class, Query.select().where("IS_ACTIVE = ? AND (START_DATE IS NULL OR START_DATE <= ?) AND (END_DATE IS NULL OR END_DATE >= ?)", new Object[]{Boolean.TRUE, now, now}));
        return Lists.newArrayList((Object[])entities);
    }

    public List<AnnouncingEntity> getPinnedEntities() {
        Date now = new Date();
        Object[] entities = (AnnouncingEntity[])this.ao.find(AnnouncingEntity.class, Query.select().where("IS_ACTIVE = ? AND IS_PINNED = ? AND (START_DATE IS NULL OR START_DATE <= ?)AND (END_DATE IS NULL OR END_DATE >= ?)", new Object[]{Boolean.TRUE, Boolean.TRUE, now, now}).order("ID ASC"));
        return Lists.newArrayList((Object[])entities);
    }

    public Integer getActiveAnnouncementSize() {
        return this.ao.count(AnnouncingEntity.class, Query.select().where("IS_ACTIVE = ?", new Object[]{Boolean.TRUE}));
    }

    public AnnouncingEntity[] getLoginFormEntities() {
        return (AnnouncingEntity[])this.ao.find(AnnouncingEntity.class, Query.select().where("IS_ACTIVE = ? AND STYLE LIKE ?", new Object[]{Boolean.TRUE, "%block-login-form%"}));
    }
}

