define("actonic-gdpr/global/rest", ["jquery"], function ($) {

    function Rest() {
        this.getAnnouncingForUser = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/announcing/next",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getAnnouncingBody = function (id, successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/announcing/html/" + id,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            })
        }
        this.acceptAnnouncing = function (announcingId, request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                data: request,
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/announcing/accept/" + announcingId,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.declineAnnouncing = function (announcingId, request, successCallback, errorCallback) {
            $.ajax({
                type: "POST",
                data: request,
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/announcing/cancel/" + announcingId,
                headers: {"X-Atlassian-Token": "no-check"},
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.getPinnedAnnouncements = function (successCallback, errorCallback) {
            $.ajax({
                type: "GET",
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/announcing/pinned",
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
        this.updatePinnedAnnouncing = function (action, announcingId, request, successCallback, errorCallback) {
            $.ajax({
                type: "PUT",
                data: request,
                url: AJS.contextPath() + "/rest/actonic-gdpr/1.0/announcing/" + action + "/" + announcingId,
                success: function (data) {
                    if (typeof successCallback === "function") successCallback(data);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    if (typeof errorCallback === "function") errorCallback(jqXHR);
                }
            });
        }
    }

    return new Rest();
});