define("gdpr/data-cleaner/issue-post-function", ["jquery", "gdpr/data-cleaner/rules/rest", "actonic-gdpr/core/flags",
    "gdpr/core/log", "gdpr/core/utils", "actonic-gdpr/core/wait-for-element", "gdpr/core/element-highlighter"],
    function ($, ruleRest, flags, log, coreUtils, WaitForElement, coreHighlighter) {
    function DataCleanerIssuePostFunction() {
        var issueFunctionPostList = [];
        var postFunctionList = [];
        var boolAnyRuleEnabled = false;
        var templateId;
        var currentEditingId;
        var successIcon = "<span class='custom-success-icon custom-icon icon'></span>";
        var errorIcon = "<span class='custom-error-icon custom-icon icon'></span>";
        var warningIcon = "<span class='custom-warning-icon custom-icon icon'></span>";

        this.init = function () {
            templateId = coreUtils.getCurrentUrlParameterByName("id");
            getRulesForTemplate();

            $("#btn-post-function").on("click", function () {
                initIssueFunctionPostDialog();
                getRulesForTemplate();
            });
        };

        function getPostFunctionList() {
            $("#post-function-tableprogress-indicator").show();

            ruleRest.getAllPostFunctions(templateId,
                function (data) {
                    postFunctionList = data;
                    data.forEach(function (pfl, i) {
                        var name = '';
                        var tempArr = pfl.rules.split(',');
                        var jCount = 1;
                        issueFunctionPostList.forEach(function (issue, j) {
                            if (tempArr.includes(issue.id.toString())) {
                                name = name + issue.name;
                                if (jCount < tempArr.length) {
                                    name = name + ', ';
                                }
                                jCount++;
                            }
                        });
                        data[i].ruleNames = name;
                    });
                    $("#post-function-tableprogress-indicator").hide();
                    var tbody = $("table#post-function-table>tbody");
                    if (data && data.length > 0) {
                        tbody.html(ACTONIC.GDPR.DATACLEANER.EDIT.postFunctionTable({list: data}));
                        $("#postfunctions-link-subtitle").html(successIcon + data.length + " " + AJS.I18n.getText("js-data-clean.template.text.post-func-defined"));
                        if ($("#has-task").val() === "false") $("#post-function-table .aui-dropdown2-trigger").show();
                    } else {
                        tbody.html(ACTONIC.GDPR.DATACLEANER.EDIT.noPostFunction);
                        $("#postfunctions-link-subtitle").html(warningIcon + AJS.I18n.getText("js-data-clean.template.text.no-post-func-defined"));
                    }
                    getActionsEvents();
                },
                function (xhr) {
                    log.error(xhr);
                    flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.warning.not-get-data"));
                });
        }

        function getActionsEvents() {
            $(".postfunc-edit").off("click");
            $(".postfunc-edit").on("click", function (event) {
                var editingPostFunction;
                var postFunctionId = $(this).attr("data-rule-id");
                postFunctionList.forEach(function (item, index) {
                    if (item.id == postFunctionId) {
                        editingPostFunction = item;
                    }
                });
                //console.log(editingPostFunction);
                editIssueFunctionPostDialog(editingPostFunction);
            });

            $(".postfunc-status").off("click");
            $(".postfunc-status").on("click", function () {
                var postFunctionId = $(this).attr("data-rule-id");
                var currentStatus = $(this).attr("data-status");
                var newStatus = currentStatus == "false" ? true : false;
                changePostFunctionStatus(postFunctionId, newStatus);
            });

            $(".postfunc-delete").off("click");
            $(".postfunc-delete").on("click", function () {
                var postFunctionId = $(this).attr("data-rule-id");
                deletePostFunction(postFunctionId);
            });
        }

        function getPostFunctionEvents() {
            $("#post-function-save-rule").off("click");
            $("#post-function-save-rule").on("click", close);

            $("#post-function-type").off("change");
            $("#post-function-type").on("change", function () {
                var post_type_type = $(this).val();
                if (post_type_type == "comment") {
                    $("#form-post-function-label").hide();
                    $("#form-post-function-notification").hide();
                    $("#form-post-function-comment").show();
                } else if (post_type_type == "label") {
                    $("#form-post-function-comment").hide();
                    $("#form-post-function-notification").hide();
                    $("#form-post-function-label").show();
                } else if (post_type_type == "notification") {
                    $("#form-post-function-comment").hide();
                    $("#form-post-function-label").hide();
                    $("#form-post-function-notification").show();
                } else {
                    $("#form-post-function-comment").hide();
                    $("#form-post-function-label").hide();
                    $("#form-post-function-notification").hide();
                }
            });

            $("#post-function-any-rules").off("change");
            $("#post-function-any-rules").on("change", function () {
                boolAnyRuleEnabled = !boolAnyRuleEnabled;
                $("#post-function-rules").prop('disabled', boolAnyRuleEnabled);

                if(boolAnyRuleEnabled) {
                    $("#post-function-rules").val(null).trigger('change');
                    $(".field-post-rules .select2-choices").css("background", "#7a869a");
                    $("#post-function-rules").auiSelect2('disable', true);
                } else {
                    setSelectDropDown();
                }
            });

            $("#post-function-save").off("click");
            $("#post-function-save").on("click", createPostFunction);

            $("#post-function-update").off("click");
            $("#post-function-update").on("click", updatePostFunction);

            $("#post-function-rule-dialog-header-close").off("click");
            $("#post-function-rule-dialog-header-close").on("click", () => AJS.dialog2("#post-function-rule-dialog").hide());
        }

        function editIssueFunctionPostDialog(objVal) {
            $("#post-function-rule-dialog").remove();
            getRulesForTemplate();

            currentEditingId = objVal.id;
            var inputs = {
                action: 'update',
                name: objVal.name,
                notificationType: objVal.notificationType,
                anyRuleEnabled: objVal.anyRuleEnabled,
                notificationParameters: {
                    comment: objVal.notificationParameters.comment ? objVal.notificationParameters.comment : '',
                    label: objVal.notificationParameters.label ? objVal.notificationParameters.label : '',
                    message: objVal.notificationParameters.message ? objVal.notificationParameters.message : '',
                    recipient: objVal.notificationParameters.recipient ? objVal.notificationParameters.recipient : '',
                    subject: objVal.notificationParameters.subject ? objVal.notificationParameters.subject : ''
                }
            };
            $("#post-dialog-placeholder").html(ACTONIC.GDPR.DATACLEANER.EDIT.newPostFunctionDialog({data: inputs}));
            AJS.dialog2("#post-function-rule-dialog").show();

            getPostFunctionEvents();
            var indexesArray = objVal.rules.split(',');
            setSelectDropDown(indexesArray);

            if (objVal.anyRuleEnabled) {
                boolAnyRuleEnabled = objVal.anyRuleEnabled;
                $("#post-function-rules").prop('disabled', objVal.anyRuleEnabled);
                $("#post-function-rules").val(null).trigger('change');
            }
            if (objVal.notificationType == "comment") {
                $("#form-post-function-label").hide();
                $("#form-post-function-notification").hide();
                $("#form-post-function-comment").show();
            } else if (objVal.notificationType == "label") {
                $("#form-post-function-comment").hide();
                $("#form-post-function-notification").hide();
                $("#form-post-function-label").show();
            } else if (objVal.notificationType == "notification") {
                $("#form-post-function-comment").hide();
                $("#form-post-function-label").hide();
                $("#form-post-function-notification").show();
            }
        }

        function initIssueFunctionPostDialog() {
            boolAnyRuleEnabled = false;
            $("#post-function-rule-dialog").remove();
            var inputs = {
                action: 'create',
                name: '',
                notificationType: '',
                anyRuleEnabled: false,
                notificationParameters: {
                    comment: '',
                    label:'',
                    message: '',
                    recipient: '',
                    subject: ''
                }
            };
            $("#post-dialog-placeholder").html(ACTONIC.GDPR.DATACLEANER.EDIT.newPostFunctionDialog({data: inputs}));
            AJS.dialog2("#post-function-rule-dialog").show();

            getPostFunctionEvents();
            setSelectDropDown();
        }

        function close() {
            AJS.dialog2("#post-function-rule-dialog").hide();
            $("#post-dialog-placeholder").html("");
            $("section#post-function-rule-dialog").remove();
        }

        function getRulesForTemplate() {
            if (templateId) {
                ruleRest.getRulesForTemplate(templateId, function (rulesData) {
                    issueFunctionPostList = rulesData;
                    getPostFunctionList();
                })
            }
        }

        function changePostFunctionStatus(postFunctionId, postFunctionStatus) {
            ruleRest.changePostFunctionStatus(postFunctionId, postFunctionStatus,
                function () {
                    getPostFunctionList();
                },
                function (xhr) {
                    log.error(xhr);
                    flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.warning.unable-change-status"));
                });
        }

        function deletePostFunction(postFunctionId) {
            ruleRest.deletPostFunction(postFunctionId,
                function () {
                    getPostFunctionList();
                },
                function (xhr) {
                    log.error(xhr);
                    flags.simpleWarning(AJS.I18n.getText("js-data-clean.template.warning.unable-delete"));
                });
        }

        function createPostFunction() {
            validatePostfunction(function (postFunctionRequest) { // success
                close();
                ruleRest.createPostFunction(postFunctionRequest,
                    function () {
                        getPostFunctionList();
                    },
                    function (xhr) {
                        log.error(xhr);
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.text.something-wrong"));
                    }
                );
            });
        }

        function updatePostFunction() {
            validatePostfunction(function (postFunctionRequest) { // success
                close();
                postFunctionRequest.id = currentEditingId;
                ruleRest.updatePostFunction(postFunctionRequest,
                    function () {
                        getPostFunctionList();
                    },
                    function (xhr) {
                        log.error(xhr);
                        flags.simpleWarning(AJS.I18n.getText("js-data-clean.rules.text.something-wrong"));
                    }
                );
            });
        }

        function getPostFunctionRequest() {
            var request = {
                name: $("#post-function-name").val(),
                rules: $("#post-function-rules").val(),
                notificationType: $("#post-function-type").val(),
                anyRuleEnabled: boolAnyRuleEnabled
            };

            if (request.notificationType == "comment") {
                var actionParameters = {
                    comment: $("#post-function-comment").val()
                };
                request.notificationParameters = actionParameters;
            }
            if (request.notificationType == "label") {
                var actionParameters = {
                    label: $("#post-function-label").val()
                }
                request.notificationParameters = actionParameters;
            }
            if (request.notificationType == "notification") {
                request.notificationParameters = {
                    subject: $("#post-function-subject").val(),
                    recipient: $("#post-function-recipient").val(),
                    message: $("#post-function-message").val()
                }
            }

            request.templateId = templateId;

            return request;
        }

        function validatePostfunction(successCallback) {
            var postFunctionRequest = getPostFunctionRequest();

            if (!postFunctionRequest.name) {
                coreHighlighter.redBorder($("#post-function-name"));
                flags.showFlag(
                    AJS.I18n.getText("warning.main.validation-error"),
                    AJS.I18n.getText("js-data-clean.template.warning.text.name"),
                    "warning");
                return;
            }
            if (!boolAnyRuleEnabled && !postFunctionRequest.rules) {
                coreHighlighter.redBorder($("#rule-table-placeholder"));
                flags.showFlag(
                    AJS.I18n.getText("warning.main.validation-error"),
                    AJS.I18n.getText("js-data-clean.template.warning.text.rules"),
                    "warning");
                return;
            }
            if (!postFunctionRequest.notificationType) {
                flags.showFlag(
                    AJS.I18n.getText("warning.main.validation-error"),
                    AJS.I18n.getText("js-data-clean.template.warning.text.type"),
                    "warning");
                return;
            }
            if (postFunctionRequest.notificationType == "comment") {
                if (!postFunctionRequest.notificationParameters.comment) {
                    coreHighlighter.redBorder($("#post-function-comment"));
                    flags.showFlag(
                        AJS.I18n.getText("js-dla-rules-flag-validation-error-comment-is-empty-title"),
                        AJS.I18n.getText("js-data-clean.template.warning.text.comment"),
                        "warning");
                    return;
                }
            }
            if (postFunctionRequest.notificationType == "label") {
                if (!postFunctionRequest.notificationParameters.label) {
                    coreHighlighter.redBorder($("#post-function-label"));
                    flags.showFlag(
                        AJS.I18n.getText("js-dla-rules-flag-validation-error-label-is-empty-title"),
                        AJS.I18n.getText("js-data-clean.template.warning.text.label"),
                        "warning");
                    return;
                }
            }
            if (postFunctionRequest.notificationType == "notification") {
                if (!postFunctionRequest.notificationParameters.subject) {
                    flags.showFlag(
                        AJS.I18n.getText("warning.main.validation-error"),
                        AJS.I18n.getText("js-data-clean.template.warning.text.subject"),
                        "warning");
                    return;
                }
                if (!postFunctionRequest.notificationParameters.message) {
                    flags.showFlag(
                        AJS.I18n.getText("warning.main.validation-error"),
                        AJS.I18n.getText("js-data-clean.template.warning.text.message"),
                        "warning");
                    return;
                }
            }
            successCallback(postFunctionRequest);
        }

        function setSelectDropDown(indexesArray) {
            $("#post-function-rules").auiSelect2('destroy');
            AJS.$("#post-function-rules").auiSelect2({
                placeholder: AJS.I18n.getText("js-data-clean.build-ins.picker.placeholder.by-category"),
                multiple: true,
                data: function () {
                    var results = [];
                    $.each(issueFunctionPostList, function (index, item) {
                        results.push({id: item.id, text: item.name});
                    });
                    return {
                        results: results
                    };
                },
                initSelection: function (element, callback) {
                    if (indexesArray && indexesArray.length > 0) {
                        var result = [];
                        issueFunctionPostList.forEach(function (single) {
                            if (indexesArray.includes(single.id.toString())) {
                                result.push({id: single.id, text: single.name});
                            }
                        });
                        callback(result);
                    }
                }
            }).auiSelect2('val', []);
        }
    }

    return new DataCleanerIssuePostFunction();
});
