define("gdpr/data-cleaner/task", ["jquery", "gdpr/data-cleaner/tasks/rest", "actonic-gdpr/core/flags", "gdpr/core/log"], function ($, Rest, flags, log) {
    function DataCleanerTasks() {
        var _this = this;
        var anonymizationRequest;

        this.init = function () {
        };

        this.initEvents = function () {
            $(".start-task").off("click");
            $(".start-task").on("click", function (event) {
                event.preventDefault();

                var templateId = $(this).attr("data-template-id");
                var taskType = $(this).attr("data-task-type");
                anonymizationRequest = {
                    templateId: templateId,
                    type: taskType
                };

                if (taskType === '1') {
                    AJS.dialog2("#confirm-anonymization-dialog").show();
                    $("#current-anonymization-name").html($("#name-" + templateId).html());
                } else {
                    Rest.createTask(anonymizationRequest, function (data) {
                        // log.debug(data);
                        $(".results[data-id='" + data.templateId + "']").attr("href", "data-cleaner-results.action?templateId=" + data.templateId + "&taskId=" + data.id);
                        $(".results[data-id='" + data.templateId + "']").show();

                        _this.showStopButtons(anonymizationRequest.templateId)
                    }, function (xhr) {
                        log.error(xhr);
                        flags.simpleWarning(xhr.responseText);
                    })
                }
            });

            $("#confirm-anonymization-confirm-btn").on("click", function(event){
                event.preventDefault();
                AJS.dialog2("#confirm-anonymization-dialog").hide();

                Rest.createTask(anonymizationRequest, function (data) {
                    // log.debug(data);
                    $(".results[data-id='" + data.templateId + "']").attr("href", "data-cleaner-results.action?templateId=" + data.templateId + "&taskId=" + data.id);
                    $(".results[data-id='" + data.templateId + "']").show();

                    _this.showStopButtons(anonymizationRequest.templateId)
                }, function (xhr) {
                    log.error(xhr);
                    flags.simpleWarning(xhr.responseText);
                })
            });

            $("#confirm-anonymization-cancel-btn").on("click", function(event){
                event.preventDefault();
                anonymizationRequest = null;
                AJS.dialog2("#confirm-anonymization-dialog").hide();
            });

            $(".stop-task").off("click");
            $(".stop-task").on("click", function (event) {
                event.preventDefault();

                var templateId = $(this).attr("data-template-id");
                var taskId = $(this).attr("data-task-id");

                Rest.cancelTask(taskId, function (data) {
                    _this.showStartButtons(templateId);
                }, function (xhr) {
                    log.error(xhr);
                    flags.simpleWarning(xhr.responseText);
                })
            })
        };

        this.showStartButtons = function (templateId) {
            $(".start-task[data-template-id='" + templateId + "']").show();
            $(".stop-task[data-template-id='" + templateId + "']").hide();
        };

        this.showStopButtons = function (templateId) {
            $(".start-task[data-template-id='" + templateId + "']").hide();
            $(".stop-task[data-template-id='" + templateId + "']").show();
        }
    }

    return new DataCleanerTasks();
});
