/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.general.manager;

import de.actonic.gdpr.general.GlobalConstants;
import de.actonic.gdpr.shared.general.manager.IGDPRGeneralConfigManager;
import de.actonic.gdpr.shared.general.manager.IGDPRPluginManager;
import de.actonic.gdpr.shared.general.manager.IGDPRUserManager;
import de.actonic.gdpr.shared.general.model.GeneralConfigModel;
import de.actonic.gdpr.shared.general.service.PluginLicenseService;
import java.util.TimeZone;
import org.springframework.stereotype.Component;

@Component
public class GDPRGeneralConfigManager
implements IGDPRGeneralConfigManager {
    private final PluginLicenseService pluginLicenseService;
    private final IGDPRPluginManager pluginManager;
    private final IGDPRUserManager userManager;

    public GDPRGeneralConfigManager(PluginLicenseService pluginLicenseService, IGDPRPluginManager pluginManager, IGDPRUserManager userManager) {
        this.pluginLicenseService = pluginLicenseService;
        this.pluginManager = pluginManager;
        this.userManager = userManager;
    }

    public GeneralConfigModel getGeneralConfig() {
        return GeneralConfigModel.builder().serverType(GlobalConstants.SERVER_TYPE).serverTimeZone(TimeZone.getDefault().getID()).serverTimeOffset(this.getServerTimeOffset()).licenseStatus(this.pluginLicenseService.getPluginLicenseStatus()).isAmplitudeEnabled(true).pluginVersion(this.pluginManager.getPluginVersion()).userAccountId(this.userManager.getLoggedUser().getUserKey()).build();
    }
}

