/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.datacleaner.rest;

import de.actonic.gdpr.shared.datacleaner.model.DCIgnoreImportExportModel;
import de.actonic.gdpr.shared.datacleaner.model.DCIgnoreModel;
import de.actonic.gdpr.shared.datacleaner.model.IgnoreListsSearchResultsModel;
import de.actonic.gdpr.shared.datacleaner.service.DCService;
import de.actonic.gdpr.shared.general.exception.GDPRException;
import de.actonic.gdpr.shared.general.exception.GDPRExceptionHandler;
import de.actonic.gdpr.shared.general.util.GDPRJsonUtils;
import de.actonic.gdpr.shared.general.util.GDPRLogHelper;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;

@Path(value="/data-cleaner")
@Produces(value={"application/json"})
public class DCRest {
    private static final Logger log = LoggerFactory.getLogger(DCRest.class);
    private final DCService dcService;

    public DCRest(DCService dcService) {
        this.dcService = dcService;
    }

    @GET
    @Path(value="/ignore/")
    public Response getIgnoreLists(@QueryParam(value="page") Integer page, @QueryParam(value="limit") Integer limit) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            IgnoreListsSearchResultsModel resultModel = this.dcService.getIgnoreLists(page, limit);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)resultModel)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/ignore/")
    public Response createIgnoreList(@RequestBody DCIgnoreModel dcIgnoreModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            DCIgnoreModel entity = this.dcService.createIgnoreList(dcIgnoreModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)entity)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @PUT
    @Path(value="/ignore/{id}")
    public Response updateIgnoreList(@PathParam(value="id") int id, @RequestBody DCIgnoreModel dcIgnoreModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            dcIgnoreModel.setId(Integer.valueOf(id));
            DCIgnoreModel entity = this.dcService.updateIgnoreList(dcIgnoreModel);
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)entity)).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @DELETE
    @Path(value="/ignore/{id}")
    public Response deleteIgnoreList(@PathParam(value="id") int id) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            this.dcService.deleteIgnoreList(id);
            log.debug(logHelper.stop());
            return Response.ok().build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @POST
    @Path(value="/ignore/import")
    public Response importIgnoreLists(@RequestBody DCIgnoreImportExportModel dcIgnoreImportExportModel) {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            this.dcService.importIgnoreLists(dcIgnoreImportExportModel);
            log.debug(logHelper.stop());
            return Response.ok().build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }

    @GET
    @Path(value="/ignore/export")
    public Response importIgnoreLists() {
        GDPRLogHelper logHelper = new GDPRLogHelper(new Object(){}.getClass().getEnclosingMethod().getName());
        log.debug(logHelper.start());
        try {
            log.debug(logHelper.stop());
            return Response.ok((Object)GDPRJsonUtils.toJson((Object)this.dcService.exportIgnoreLists())).build();
        }
        catch (GDPRException e) {
            log.debug(logHelper.stop());
            return GDPRExceptionHandler.handler((GDPRException)e);
        }
    }
}

