/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.gdpr.announcement.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import de.actonic.confluence.gdpr.component.manager.AbstractEntityDao;
import de.actonic.gdpr.announcement.ao.AnnouncementHistoryEntity;
import de.actonic.gdpr.general.manager.GDPRAbstractEntityDao;
import de.actonic.gdpr.shared.general.util.GDPRAssertUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncementHistoryDao
extends AbstractEntityDao {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementHistoryDao.class);

    @Autowired
    public AnnouncementHistoryDao(@ComponentImport ActiveObjects ao) {
        super(ao);
    }

    public List<AnnouncementHistoryEntity> getAllEntities() {
        Object[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class);
        return Lists.newArrayList((Object[])entities);
    }

    public List<AnnouncementHistoryEntity> getAllEntitiesByUser(String userName) {
        Object[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("USER = ?", new Object[]{userName}));
        return Lists.newArrayList((Object[])entities);
    }

    public List<AnnouncementHistoryEntity> getAllEntitiesByAnnouncingId(int announcingId) {
        Object[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ?", new Object[]{announcingId}));
        return Lists.newArrayList((Object[])entities);
    }

    public List<AnnouncementHistoryEntity> getAllEntitiesByUserAndAnnouncingId(String userKey, int announcingId) {
        Object[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("USER = ? AND ANNOUNCING_ID = ?", new Object[]{userKey, announcingId}));
        return Lists.newArrayList((Object[])entities);
    }

    public boolean isUserAcceptedAnnouncing(String user, int announcingId) {
        log.debug("Trying to find accepted/declined announcements for id = '" + announcingId + "' and userKey = '" + user + "'");
        Query query = Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, user});
        Object[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, query);
        log.debug("Found " + entities.length + " results");
        return Lists.newArrayList((Object[])entities).size() > 0;
    }

    public int getAcceptedCount(int announcingId) {
        AnnouncementHistoryEntity[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND ANSWER = ?", new Object[]{announcingId, "accepted"}));
        return entities.length;
    }

    public int getDeclinedCount(int announcingId) {
        AnnouncementHistoryEntity[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND ANSWER = ?", new Object[]{announcingId, "declined"}));
        return entities.length;
    }

    public String getQueResponse(int announcingId, String userKey) {
        AnnouncementHistoryEntity[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, userKey}));
        return entities.length > 0 ? entities[0].getQuestionnaire() : "";
    }

    public AnnouncementHistoryEntity createEntity(int announcingId, Integer version, String name, String user, String answer, String questionnaire, String ip) {
        return (AnnouncementHistoryEntity)this.ao.executeInTransaction(() -> {
            AnnouncementHistoryEntity entity = (AnnouncementHistoryEntity)this.ao.create(AnnouncementHistoryEntity.class, new DBParam[0]);
            entity.setAnnouncingId(announcingId);
            entity.setVersion(version);
            entity.setName(name);
            entity.setUser(user);
            entity.setTimeStamp(new Date());
            entity.setAnswer(answer);
            entity.setQuestionnaire(questionnaire);
            entity.setIp(ip);
            entity.save();
            return entity;
        });
    }

    public void clearAnnouncing(int announcingId) {
        AnnouncementHistoryEntity[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ?", new Object[]{announcingId}));
        this.ao.delete((RawEntity[])entities);
    }

    public boolean updateAnnouncingAnswerByIdAndUser(int announcingId, String answer, String user, String questionnaire) {
        AnnouncementHistoryEntity[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, user}));
        if (entities.length > 0) {
            AnnouncementHistoryEntity current = entities[0];
            current.setTimeStamp(new Date());
            current.setAnswer(answer);
            current.setQuestionnaire(questionnaire);
            current.save();
            return true;
        }
        return false;
    }

    public AnnouncementHistoryEntity getHistoryByIdAndUser(int announcingId, String userKey) {
        AnnouncementHistoryEntity[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, userKey}));
        return entities.length > 0 ? entities[0] : null;
    }

    public boolean hasAnswerByIdAndUser(int announcingId, String userKey) {
        AnnouncementHistoryEntity[] announcingHistoryEntities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, userKey}));
        return announcingHistoryEntities.length > 0;
    }

    public String getAnswerByIdAndUser(int announcingId, String user) {
        AnnouncementHistoryEntity[] announcingHistoryEntities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, Query.select().where("ANNOUNCING_ID = ? AND USER = ?", new Object[]{announcingId, user}));
        return announcingHistoryEntities.length > 0 ? announcingHistoryEntities[0].getAnswer() : "unknown";
    }

    public boolean isVisitedAlready(int announcingId, String userName) {
        return this.ao.count(AnnouncementHistoryEntity.class, Query.select().where("USER = ? AND ANNOUNCING_ID = ?", new Object[]{userName, announcingId})) > 0;
    }

    public void clearByAnnouncementIds(List<Integer> announcementIds) {
        GDPRAssertUtils.partition(announcementIds, (int)1000).forEach(ids -> {
            Query query = Query.select();
            query.setWhereClause(GDPRAbstractEntityDao.createWhereClause(ids, ",", "ANNOUNCING_ID IN (", ") "));
            query.setWhereParams(ids.toArray());
            AnnouncementHistoryEntity[] entities = (AnnouncementHistoryEntity[])this.ao.find(AnnouncementHistoryEntity.class, query);
            if (entities != null && entities.length > 0) {
                this.ao.delete((RawEntity[])entities);
            }
        });
    }

    public List<AnnouncementHistoryEntity> getFilteredHistoryAnnouncements(String userKey, Integer announcementId, Integer version, Date fromDate, Date toDate) {
        Query query = Query.select().order("ID ASC");
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        if (userKey != null) {
            this.addDelimiterIfNotNull(sb);
            sb.append("USER = ?");
            values.add(userKey);
        }
        if (announcementId != null) {
            this.addDelimiterIfNotNull(sb);
            sb.append("ANNOUNCING_ID = ?");
            values.add(announcementId);
        }
        if (version != null) {
            this.addDelimiterIfNotNull(sb);
            sb.append("VERSION = ?");
            values.add(version);
        }
        if (fromDate != null) {
            this.addDelimiterIfNotNull(sb);
            sb.append("TIME_STAMP >= ?");
            values.add(fromDate);
        }
        if (toDate != null) {
            this.addDelimiterIfNotNull(sb);
            sb.append("TIME_STAMP <= ?");
            values.add(toDate);
        }
        if (sb.length() > 0) {
            query.setWhereClause(sb.toString());
            query.setWhereParams(values.toArray());
        }
        return Lists.newArrayList((Object[])this.ao.find(AnnouncementHistoryEntity.class, query));
    }

    private void addDelimiterIfNotNull(StringBuilder sb) {
        if (sb.length() > 0) {
            sb.append(" AND ");
        }
    }
}

