/*
 * Decompiled with CFR 0.152.
 */
package de.actonic.confluence.gdpr.component.service;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.user.User;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import de.actonic.confluence.gdpr.component.manager.CqlManager;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.AttachmentCreatorChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.CommentAuthorChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.DigitalSignatureChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.PageCreatorChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.PagePermissionChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.PersonalSpaceChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.SpaceCreatorChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.SpacePermissionChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.UserMentionChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.content.WatcherChanger;
import de.actonic.confluence.gdpr.component.service.anonymizer.global.DeleteFromGroups;
import de.actonic.confluence.gdpr.component.service.anonymizer.global.UserDataChanger;
import de.actonic.confluence.gdpr.model.ContentChangerResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAnonymizerService {
    private static final Logger log = LoggerFactory.getLogger(UserAnonymizerService.class);
    @ComponentImport
    private final SchedulerService schedulerService;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final SpaceManager spaceManager;
    @ComponentImport
    private final PageManager pageManager;
    @ComponentImport
    private final CacheManager cacheManager;
    @ComponentImport
    private final EventPublisher eventPublisher;
    private final PluginSettings pluginSettings;
    private CqlManager cqlManager;
    private AttachmentCreatorChanger attachmentCreatorChanger;
    private CommentAuthorChanger commentAuthorChanger;
    private PageCreatorChanger pageCreatorChanger;
    private PersonalSpaceChanger personalSpaceChanger;
    private SpaceCreatorChanger spaceCreatorChanger;
    private UserMentionChanger userMentionChanger;
    private WatcherChanger watcherChanger;
    private PagePermissionChanger pagePermissionChanger;
    private SpacePermissionChanger spacePermissionChanger;
    private DeleteFromGroups deleteFromGroups;
    private UserDataChanger userDataChanger;
    private DigitalSignatureChanger digitalSignatureChanger;
    private static final String USER_ANONYMIZATION_EVENT = "USER_ANONYMIZATION_EVENT";

    @Autowired
    public UserAnonymizerService(SchedulerService schedulerService, PluginSettingsFactory pluginSettingsFactory, UserAccessor userAccessor, SpaceManager spaceManager, PageManager pageManager, CacheManager cacheManager, EventPublisher eventPublisher, CqlManager cqlManager, AttachmentCreatorChanger attachmentCreatorChanger, CommentAuthorChanger commentAuthorChanger, PageCreatorChanger pageCreatorChanger, PersonalSpaceChanger personalSpaceChanger, SpaceCreatorChanger spaceCreatorChanger, UserMentionChanger userMentionChanger, WatcherChanger watcherChanger, PagePermissionChanger pagePermissionChanger, SpacePermissionChanger spacePermissionChanger, DeleteFromGroups deleteFromGroups, UserDataChanger userDataChanger, DigitalSignatureChanger digitalSignatureChanger) {
        this.schedulerService = schedulerService;
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("de.actonic.confluence.gdpr.component.service.UserAnonymizerService");
        this.userAccessor = userAccessor;
        this.spaceManager = spaceManager;
        this.pageManager = pageManager;
        this.cacheManager = cacheManager;
        this.eventPublisher = eventPublisher;
        this.cqlManager = cqlManager;
        this.attachmentCreatorChanger = attachmentCreatorChanger;
        this.commentAuthorChanger = commentAuthorChanger;
        this.pageCreatorChanger = pageCreatorChanger;
        this.personalSpaceChanger = personalSpaceChanger;
        this.spaceCreatorChanger = spaceCreatorChanger;
        this.userMentionChanger = userMentionChanger;
        this.watcherChanger = watcherChanger;
        this.pagePermissionChanger = pagePermissionChanger;
        this.spacePermissionChanger = spacePermissionChanger;
        this.deleteFromGroups = deleteFromGroups;
        this.userDataChanger = userDataChanger;
        this.digitalSignatureChanger = digitalSignatureChanger;
    }

    public String runGlobalChanges(Map<String, String> configurationMap) {
        ContentChangerResult changerResult;
        String historyMessage = "";
        String userName = configurationMap.get("userName");
        ConfluenceUser sourceUser = this.userAccessor.getUserByName(userName);
        String target = configurationMap.get("target");
        ConfluenceUser targetUser = this.userAccessor.getUserByName(target);
        if (this.getBooleanFromConfig(configurationMap.get(this.deleteFromGroups.getChangerName()))) {
            changerResult = this.deleteFromGroups.changeIssues("actonic-gdpr-user-anonymizer-global-changes", sourceUser);
            historyMessage = historyMessage + "Successfully removed from groups " + changerResult.getSuccessfullyChanged() + "\n";
            if (!Strings.isNullOrEmpty((String)changerResult.getBadlyChanged())) {
                historyMessage = historyMessage + "Failed to remove from groups " + changerResult.getBadlyChanged() + "\n";
            }
        }
        if (this.getBooleanFromConfig(configurationMap.get(this.userDataChanger.getChangerName()))) {
            changerResult = this.userDataChanger.changeIssues("actonic-gdpr-user-anonymizer-global-changes", sourceUser);
            historyMessage = historyMessage + "Successfully cleared user data " + changerResult.getSuccessfullyChanged() + "\n";
            if (!Strings.isNullOrEmpty((String)changerResult.getBadlyChanged())) {
                historyMessage = historyMessage + "Failed to clear user data " + changerResult.getBadlyChanged() + "\n";
            }
        }
        if (this.getBooleanFromConfig(configurationMap.get("disable"))) {
            this.userAccessor.deactivateUser((User)sourceUser);
            historyMessage = historyMessage + "User successfully disabled\n";
        }
        if (this.getBooleanFromConfig(configurationMap.get("event"))) {
            Properties payload = new Properties();
            payload.setProperty("emitter", USER_ANONYMIZATION_EVENT);
            if (sourceUser != null) {
                payload.setProperty("sourceUsername", sourceUser.getName());
                payload.setProperty("sourceDisplayName", sourceUser.getFullName());
                payload.setProperty("sourceKey", sourceUser.getKey().getStringValue());
                payload.setProperty("sourceEmail", sourceUser.getEmail());
            }
            if (targetUser != null) {
                payload.setProperty("targetUsername", targetUser.getName());
                payload.setProperty("targetDisplayName", targetUser.getFullName());
                payload.setProperty("targetKey", targetUser.getKey().getStringValue());
                payload.setProperty("targetEmail", targetUser.getEmail());
            }
            this.eventPublisher.publish((Object)payload);
        }
        return historyMessage;
    }

    public String getStatus(String jobId) {
        log.debug("getStatus jobId = " + jobId);
        Object jobStatusObj = this.pluginSettings.get(jobId);
        if (jobStatusObj != null) {
            return (String)jobStatusObj;
        }
        return "{\"status\": \"error\", \"message\": \"unknown job id\"}";
    }

    public String runContentChanges(final Map<String, String> configurationMap) {
        final ConfluenceUser remoteUser = AuthenticatedUserThreadLocal.get();
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)"actonic-gdpr-user-anonymizer-job-runner");
        this.schedulerService.registerJobRunner(jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
                log.debug("Started JobRunner contentChanges");
                String jobId = jobRunnerRequest.getJobId().toString();
                UserAnonymizerService.this.setJobMessage(jobId, "Preparing to content changes...");
                AuthenticatedUserThreadLocal.set((ConfluenceUser)remoteUser);
                try {
                    String cql;
                    String sourceUserName = (String)configurationMap.get("sourceUserName");
                    ConfluenceUser sourceUser = UserAnonymizerService.this.userAccessor.getUserByName(sourceUserName);
                    log.debug("> sourceUser found = " + (sourceUser != null));
                    String targetUserName = (String)configurationMap.get("targetUserName");
                    ConfluenceUser targetUser = UserAnonymizerService.this.userAccessor.getUserByName(targetUserName);
                    log.debug("> targetUser found = " + (targetUser != null));
                    ArrayList contentChangerResults = Lists.newArrayList();
                    if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.watcherChanger.getChangerName()))) {
                        try {
                            log.debug("> trying to change watcherChanger");
                            contentChangerResults.add(UserAnonymizerService.this.watcherChanger.changeIssues(jobId, null, sourceUser, targetUser));
                            log.debug("++ SUCCESS for watcherChanger");
                        }
                        catch (Exception e) {
                            log.error("-- FAILED for watcherChanger (" + e.getMessage() + ")");
                        }
                    }
                    if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.personalSpaceChanger.getChangerName()))) {
                        try {
                            log.debug("> trying to change personalSpaceChanger");
                            contentChangerResults.add(UserAnonymizerService.this.personalSpaceChanger.changeIssues(jobId, null, sourceUser, targetUser));
                            log.debug("++ SUCCESS for personalSpaceChanger");
                        }
                        catch (Exception e) {
                            log.error("-- FAILED for personalSpaceChanger (" + e.getMessage() + ")");
                        }
                    }
                    if (Strings.isNullOrEmpty((String)(cql = (String)configurationMap.get("cql")))) {
                        log.debug("!! no cql is defined, search through all spaces");
                        for (Space space : UserAnonymizerService.this.spaceManager.getAllSpaces()) {
                            ArrayList pageList = new ArrayList();
                            pageList.addAll(UserAnonymizerService.this.pageManager.getPages(space, true));
                            log.debug("!! added all pages in space " + space.getKey());
                            pageList.addAll(UserAnonymizerService.this.pageManager.getBlogPosts(space, true));
                            log.debug("!! added all blogposts in space " + space.getKey());
                            for (AbstractPage page : pageList) {
                                log.debug("!!! working with page = " + page.getId());
                                if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.attachmentCreatorChanger.getChangerName()))) {
                                    try {
                                        log.debug("> trying to change attachmentCreatorChanger");
                                        contentChangerResults.add(UserAnonymizerService.this.attachmentCreatorChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                        log.debug("++ SUCCESS for attachmentCreatorChanger");
                                    }
                                    catch (Exception e) {
                                        log.error("-- FAILED for attachmentCreatorChanger (" + e.getMessage() + ")");
                                    }
                                }
                                if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.commentAuthorChanger.getChangerName()))) {
                                    try {
                                        log.debug("> trying to change commentAuthorChanger");
                                        contentChangerResults.add(UserAnonymizerService.this.commentAuthorChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                        log.debug("++ SUCCESS for commentAuthorChanger");
                                    }
                                    catch (Exception e) {
                                        log.error("-- FAILED for commentAuthorChanger (" + e.getMessage() + ")");
                                    }
                                }
                                if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.pageCreatorChanger.getChangerName()))) {
                                    try {
                                        log.debug("> trying to change pageCreatorChanger");
                                        contentChangerResults.add(UserAnonymizerService.this.pageCreatorChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                        log.debug("++ SUCCESS for pageCreatorChanger");
                                    }
                                    catch (Exception e) {
                                        log.error("-- FAILED for pageCreatorChanger (" + e.getMessage() + ")");
                                    }
                                }
                                if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.userMentionChanger.getChangerName()))) {
                                    try {
                                        log.debug("> trying to change userMentionChanger");
                                        contentChangerResults.add(UserAnonymizerService.this.userMentionChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                        log.debug("++ SUCCESS for userMentionChanger");
                                    }
                                    catch (Exception e) {
                                        log.error("-- FAILED for userMentionChanger (" + e.getMessage() + ")");
                                    }
                                }
                                if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.pagePermissionChanger.getChangerName()))) {
                                    try {
                                        log.debug("> trying to change pagePermissionChanger");
                                        contentChangerResults.add(UserAnonymizerService.this.pagePermissionChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                        log.debug("++ SUCCESS for pagePermissionChanger");
                                    }
                                    catch (Exception e) {
                                        log.error("-- FAILED for pagePermissionChanger (" + e.getMessage() + ")");
                                    }
                                }
                                if (!UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.digitalSignatureChanger.getChangerName()))) continue;
                                try {
                                    log.debug("> trying to change digitalSignatureChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.digitalSignatureChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for digitalSignatureChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for digitalSignatureChanger (" + e.getMessage() + ")");
                                }
                            }
                            log.debug("!!! working with space = " + space.getKey());
                            if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.spaceCreatorChanger.getChangerName()))) {
                                try {
                                    log.debug("> trying to change spaceCreatorChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.spaceCreatorChanger.changeIssues(jobId, (EntityObject)space, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for spaceCreatorChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for spaceCreatorChanger (" + e.getMessage() + ")");
                                }
                            }
                            if (!UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.spacePermissionChanger.getChangerName()))) continue;
                            try {
                                log.debug("> trying to change spacePermissionChanger");
                                contentChangerResults.add(UserAnonymizerService.this.spacePermissionChanger.changeIssues(jobId, (EntityObject)space, sourceUser, targetUser));
                                log.debug("++ SUCCESS for spacePermissionChanger");
                            }
                            catch (Exception e) {
                                log.error("-- FAILED for spacePermissionChanger (" + e.getMessage() + ")");
                            }
                        }
                    } else {
                        List<AbstractPage> pageList = UserAnonymizerService.this.cqlManager.getContentFromCql(cql, false);
                        HashSet<Space> spaces = new HashSet<Space>();
                        for (AbstractPage page : pageList) {
                            log.debug("!!! working with page = " + page.getId());
                            if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.attachmentCreatorChanger.getChangerName()))) {
                                try {
                                    log.debug("> trying to change attachmentCreatorChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.attachmentCreatorChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for attachmentCreatorChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for attachmentCreatorChanger (" + e.getMessage() + ")");
                                }
                            }
                            if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.commentAuthorChanger.getChangerName()))) {
                                try {
                                    log.debug("> trying to change commentAuthorChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.commentAuthorChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for commentAuthorChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for commentAuthorChanger (" + e.getMessage() + ")");
                                }
                            }
                            if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.pageCreatorChanger.getChangerName()))) {
                                try {
                                    log.debug("> trying to change pageCreatorChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.pageCreatorChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for pageCreatorChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for pageCreatorChanger (" + e.getMessage() + ")");
                                }
                            }
                            if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.userMentionChanger.getChangerName()))) {
                                try {
                                    log.debug("> trying to change userMentionChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.userMentionChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for userMentionChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for userMentionChanger (" + e.getMessage() + ")");
                                }
                            }
                            if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.pagePermissionChanger.getChangerName()))) {
                                try {
                                    log.debug("> trying to change pagePermissionChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.pagePermissionChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for pagePermissionChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for pagePermissionChanger (" + e.getMessage() + ")");
                                }
                            }
                            if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.digitalSignatureChanger.getChangerName()))) {
                                try {
                                    log.debug("> trying to change digitalSignatureChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.digitalSignatureChanger.changeIssues(jobId, (EntityObject)page, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for digitalSignatureChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for digitalSignatureChanger (" + e.getMessage() + ")");
                                }
                            }
                            spaces.add(page.getSpace());
                        }
                        for (Space space : spaces) {
                            log.debug("!!! working with space = " + space.getKey());
                            if (UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.spaceCreatorChanger.getChangerName()))) {
                                try {
                                    log.debug("> trying to change spaceCreatorChanger");
                                    contentChangerResults.add(UserAnonymizerService.this.spaceCreatorChanger.changeIssues(jobId, (EntityObject)space, sourceUser, targetUser));
                                    log.debug("++ SUCCESS for spaceCreatorChanger");
                                }
                                catch (Exception e) {
                                    log.error("-- FAILED for spaceCreatorChanger (" + e.getMessage() + ")");
                                }
                            }
                            if (!UserAnonymizerService.this.getBooleanFromConfig((String)configurationMap.get(UserAnonymizerService.this.spacePermissionChanger.getChangerName()))) continue;
                            try {
                                log.debug("> trying to change spacePermissionChanger");
                                contentChangerResults.add(UserAnonymizerService.this.spacePermissionChanger.changeIssues(jobId, (EntityObject)space, sourceUser, targetUser));
                                log.debug("++ SUCCESS for spacePermissionChanger");
                            }
                            catch (Exception e) {
                                log.error("-- FAILED for spacePermissionChanger (" + e.getMessage() + ")");
                            }
                        }
                    }
                    try {
                        ManagedCache cpCache;
                        ManagedCache cpsCache = UserAnonymizerService.this.cacheManager.getManagedCache("com.atlassian.confluence.security.ContentPermissionSet");
                        if (cpsCache != null) {
                            cpsCache.clear();
                        }
                        if ((cpCache = UserAnonymizerService.this.cacheManager.getManagedCache("com.atlassian.confluence.security.ContentPermission")) != null) {
                            cpCache.clear();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    UserAnonymizerService.this.setFinishJobMessage(jobId, "Completed!", UserAnonymizerService.this.convertChangerResult(contentChangerResults));
                    log.debug("Finished JobRunner contentChanges");
                    return JobRunnerResponse.success((String)"message");
                }
                catch (Exception e) {
                    UserAnonymizerService.this.setFinishJobMessage(jobId, "Failed!", Lists.newArrayList());
                    log.debug("Failed JobRunner contentChanges");
                    e.printStackTrace();
                    return JobRunnerResponse.failed((String)e.getMessage());
                }
            }
        });
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce(null));
        try {
            return this.schedulerService.scheduleJobWithGeneratedId(jobConfig).toString();
        }
        catch (SchedulerServiceException sse) {
            throw new SchedulerRuntimeException(sse.getMessage(), (Throwable)sse);
        }
    }

    public Collection<ContentChangerResult> getAffectedContent(Map<String, String> configurationMap) {
        String cql;
        log.debug("Started getAffectedContent");
        String sourceUserName = configurationMap.get("sourceUserName");
        ConfluenceUser sourceUser = this.userAccessor.getUserByName(sourceUserName);
        log.debug("source user found = " + (sourceUser != null));
        ArrayList contentChangerResults = Lists.newArrayList();
        if (this.getBooleanFromConfig(configurationMap.get(this.watcherChanger.getChangerName()))) {
            try {
                log.debug("> trying to get watcherChanger");
                contentChangerResults.add(new ContentChangerResult(this.watcherChanger.getChangerName(), this.watcherChanger.getAffectedContent(null, sourceUser)));
                log.debug("++ SUCCESS for watcherChanger");
            }
            catch (Exception e) {
                log.error("-- FAILED for watcherChanger (" + e.getMessage() + ")");
            }
        }
        if (this.getBooleanFromConfig(configurationMap.get(this.personalSpaceChanger.getChangerName()))) {
            try {
                log.debug("> trying to get personalSpaceChanger");
                contentChangerResults.add(new ContentChangerResult(this.personalSpaceChanger.getChangerName(), this.personalSpaceChanger.getAffectedContent(null, sourceUser)));
                log.debug("++ SUCCESS for personalSpaceChanger");
            }
            catch (Exception e) {
                log.error("-- FAILED for personalSpaceChanger (" + e.getMessage() + ")");
            }
        }
        if (Strings.isNullOrEmpty((String)(cql = configurationMap.get("cql")))) {
            log.debug("!! no cql is defined, search through all spaces");
            for (Space space : this.spaceManager.getAllSpaces()) {
                ArrayList pageList = new ArrayList();
                pageList.addAll(this.pageManager.getPages(space, true));
                log.debug("!! added all pages in space " + space.getKey());
                pageList.addAll(this.pageManager.getBlogPosts(space, true));
                log.debug("!! added all blogposts in space " + space.getKey());
                for (AbstractPage page : pageList) {
                    log.debug("!!! working with page = " + page.getId());
                    if (this.getBooleanFromConfig(configurationMap.get(this.attachmentCreatorChanger.getChangerName()))) {
                        try {
                            log.debug("> trying to get attachmentCreatorChanger");
                            contentChangerResults.add(new ContentChangerResult(this.attachmentCreatorChanger.getChangerName(), this.attachmentCreatorChanger.getAffectedContent((EntityObject)page, sourceUser)));
                            log.debug("++ SUCCESS for attachmentCreatorChanger");
                        }
                        catch (Exception e) {
                            log.error("-- FAILED for attachmentCreatorChanger (" + e.getMessage() + ")");
                        }
                    }
                    if (this.getBooleanFromConfig(configurationMap.get(this.commentAuthorChanger.getChangerName()))) {
                        try {
                            log.debug("> trying to get commentAuthorChanger");
                            contentChangerResults.add(new ContentChangerResult(this.commentAuthorChanger.getChangerName(), this.commentAuthorChanger.getAffectedContent((EntityObject)page, sourceUser)));
                            log.debug("++ SUCCESS for commentAuthorChanger");
                        }
                        catch (Exception e) {
                            log.error("-- FAILED for commentAuthorChanger (" + e.getMessage() + ")");
                        }
                    }
                    if (this.getBooleanFromConfig(configurationMap.get(this.pageCreatorChanger.getChangerName()))) {
                        try {
                            log.debug("> trying to get pageCreatorChanger");
                            contentChangerResults.add(new ContentChangerResult(this.pageCreatorChanger.getChangerName(), this.pageCreatorChanger.getAffectedContent((EntityObject)page, sourceUser)));
                            log.debug("++ SUCCESS for pageCreatorChanger");
                        }
                        catch (Exception e) {
                            log.error("-- FAILED for pageCreatorChanger (" + e.getMessage() + ")");
                        }
                    }
                    if (this.getBooleanFromConfig(configurationMap.get(this.userMentionChanger.getChangerName()))) {
                        try {
                            log.debug("> trying to get userMentionChanger");
                            contentChangerResults.add(new ContentChangerResult(this.userMentionChanger.getChangerName(), this.userMentionChanger.getAffectedContent((EntityObject)page, sourceUser)));
                            log.debug("++ SUCCESS for userMentionChanger");
                        }
                        catch (Exception e) {
                            log.error("-- FAILED for userMentionChanger (" + e.getMessage() + ")");
                        }
                    }
                    if (this.getBooleanFromConfig(configurationMap.get(this.pagePermissionChanger.getChangerName()))) {
                        try {
                            log.debug("> trying to get pagePermissionChanger");
                            contentChangerResults.add(new ContentChangerResult(this.pagePermissionChanger.getChangerName(), this.pagePermissionChanger.getAffectedContent((EntityObject)page, sourceUser)));
                            log.debug("++ SUCCESS for pagePermissionChanger");
                        }
                        catch (Exception e) {
                            log.error("-- FAILED for pagePermissionChanger (" + e.getMessage() + ")");
                        }
                    }
                    if (!this.getBooleanFromConfig(configurationMap.get(this.digitalSignatureChanger.getChangerName()))) continue;
                    try {
                        log.debug("> trying to get digitalSignatureChanger");
                        contentChangerResults.add(new ContentChangerResult(this.digitalSignatureChanger.getChangerName(), this.digitalSignatureChanger.getAffectedContent((EntityObject)page, sourceUser)));
                        log.debug("++ SUCCESS for digitalSignatureChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for digitalSignatureChanger (" + e.getMessage() + ")");
                    }
                }
                log.debug("!!! working with space = " + space.getKey());
                if (this.getBooleanFromConfig(configurationMap.get(this.spaceCreatorChanger.getChangerName()))) {
                    try {
                        log.debug("> trying to get spaceCreatorChanger");
                        contentChangerResults.add(new ContentChangerResult(this.spaceCreatorChanger.getChangerName(), this.spaceCreatorChanger.getAffectedContent((EntityObject)space, sourceUser)));
                        log.debug("++ SUCCESS for spaceCreatorChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for spaceCreatorChanger (" + e.getMessage() + ")");
                    }
                }
                if (!this.getBooleanFromConfig(configurationMap.get(this.spacePermissionChanger.getChangerName()))) continue;
                try {
                    log.debug("> trying to get spacePermissionChanger");
                    contentChangerResults.add(new ContentChangerResult(this.spacePermissionChanger.getChangerName(), this.spacePermissionChanger.getAffectedContent((EntityObject)space, sourceUser)));
                    log.debug("++ SUCCESS for spacePermissionChanger");
                }
                catch (Exception e) {
                    log.error("-- FAILED for spacePermissionChanger (" + e.getMessage() + ")");
                }
            }
        } else {
            List<AbstractPage> pageList = this.cqlManager.getContentFromCql(cql, false);
            log.debug("!! cql found, added " + pageList.size() + " items");
            HashSet<Space> spaces = new HashSet<Space>();
            for (AbstractPage page : pageList) {
                log.debug("!!! working with page = " + page.getId());
                if (this.getBooleanFromConfig(configurationMap.get(this.attachmentCreatorChanger.getChangerName()))) {
                    try {
                        log.debug("> trying to get attachmentCreatorChanger");
                        contentChangerResults.add(new ContentChangerResult(this.attachmentCreatorChanger.getChangerName(), this.attachmentCreatorChanger.getAffectedContent((EntityObject)page, sourceUser)));
                        log.debug("++ SUCCESS for attachmentCreatorChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for attachmentCreatorChanger (" + e.getMessage() + ")");
                    }
                }
                if (this.getBooleanFromConfig(configurationMap.get(this.commentAuthorChanger.getChangerName()))) {
                    try {
                        log.debug("> trying to get commentAuthorChanger");
                        contentChangerResults.add(new ContentChangerResult(this.commentAuthorChanger.getChangerName(), this.commentAuthorChanger.getAffectedContent((EntityObject)page, sourceUser)));
                        log.debug("++ SUCCESS for commentAuthorChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for commentAuthorChanger (" + e.getMessage() + ")");
                    }
                }
                if (this.getBooleanFromConfig(configurationMap.get(this.pageCreatorChanger.getChangerName()))) {
                    try {
                        log.debug("> trying to get pageCreatorChanger");
                        contentChangerResults.add(new ContentChangerResult(this.pageCreatorChanger.getChangerName(), this.pageCreatorChanger.getAffectedContent((EntityObject)page, sourceUser)));
                        log.debug("++ SUCCESS for pageCreatorChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for pageCreatorChanger (" + e.getMessage() + ")");
                    }
                }
                if (this.getBooleanFromConfig(configurationMap.get(this.userMentionChanger.getChangerName()))) {
                    try {
                        log.debug("> trying to get userMentionChanger");
                        contentChangerResults.add(new ContentChangerResult(this.userMentionChanger.getChangerName(), this.userMentionChanger.getAffectedContent((EntityObject)page, sourceUser)));
                        log.debug("++ SUCCESS for userMentionChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for userMentionChanger (" + e.getMessage() + ")");
                    }
                }
                if (this.getBooleanFromConfig(configurationMap.get(this.pagePermissionChanger.getChangerName()))) {
                    try {
                        log.debug("> trying to get pagePermissionChanger");
                        contentChangerResults.add(new ContentChangerResult(this.pagePermissionChanger.getChangerName(), this.pagePermissionChanger.getAffectedContent((EntityObject)page, sourceUser)));
                        log.debug("++ SUCCESS for pagePermissionChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for pagePermissionChanger (" + e.getMessage() + ")");
                    }
                }
                if (this.getBooleanFromConfig(configurationMap.get(this.digitalSignatureChanger.getChangerName()))) {
                    try {
                        log.debug("> trying to get digitalSignatureChanger");
                        contentChangerResults.add(new ContentChangerResult(this.digitalSignatureChanger.getChangerName(), this.digitalSignatureChanger.getAffectedContent((EntityObject)page, sourceUser)));
                        log.debug("++ SUCCESS for digitalSignatureChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for digitalSignatureChanger (" + e.getMessage() + ")");
                    }
                }
                spaces.add(page.getSpace());
            }
            for (Space space : spaces) {
                log.debug("!!! working with space = " + space.getKey());
                if (this.getBooleanFromConfig(configurationMap.get(this.spaceCreatorChanger.getChangerName()))) {
                    try {
                        log.debug("> trying to get spaceCreatorChanger");
                        contentChangerResults.add(new ContentChangerResult(this.spaceCreatorChanger.getChangerName(), this.spaceCreatorChanger.getAffectedContent((EntityObject)space, sourceUser)));
                        log.debug("++ SUCCESS for spaceCreatorChanger");
                    }
                    catch (Exception e) {
                        log.error("-- FAILED for spaceCreatorChanger (" + e.getMessage() + ")");
                    }
                }
                if (!this.getBooleanFromConfig(configurationMap.get(this.spacePermissionChanger.getChangerName()))) continue;
                try {
                    log.debug("> trying to get spacePermissionChanger");
                    contentChangerResults.add(new ContentChangerResult(this.spacePermissionChanger.getChangerName(), this.spacePermissionChanger.getAffectedContent((EntityObject)space, sourceUser)));
                    log.debug("++ SUCCESS for spacePermissionChanger");
                }
                catch (Exception e) {
                    log.error("-- FAILED for spacePermissionChanger (" + e.getMessage() + ")");
                }
            }
        }
        log.debug("Finished getAffectedContent");
        return this.convertChangerResult(contentChangerResults);
    }

    private boolean getBooleanFromConfig(String valueAsString) {
        if (Strings.isNullOrEmpty((String)valueAsString)) {
            return false;
        }
        return Boolean.valueOf(valueAsString);
    }

    private void setJobMessage(String jobId, String message) {
        HashMap<String, String> messageMap = new HashMap<String, String>();
        messageMap.put("status", "in progress");
        messageMap.put("message", message);
        this.pluginSettings.put(jobId, (Object)new Gson().toJson(messageMap));
    }

    private void setFinishJobMessage(String jobId, String message, Collection<ContentChangerResult> contentChangerResults) {
        HashMap<String, Object> messageMap = new HashMap<String, Object>();
        messageMap.put("status", "done");
        messageMap.put("message", message);
        messageMap.put("results", contentChangerResults);
        this.pluginSettings.put(jobId, (Object)new Gson().toJson(messageMap));
    }

    private Collection<ContentChangerResult> convertChangerResult(Collection<ContentChangerResult> oldResults) {
        HashMap<String, ContentChangerResult> tempResults = new HashMap<String, ContentChangerResult>();
        for (ContentChangerResult result : oldResults) {
            if (tempResults.containsKey(result.getChangerName())) {
                ContentChangerResult tempContentResult = (ContentChangerResult)tempResults.get(result.getChangerName());
                ContentChangerResult contentResult = new ContentChangerResult(result.getChangerName(), tempContentResult.getAffectedContent() + result.getAffectedContent(), tempContentResult.getSuccessfullyChanged() + result.getSuccessfullyChanged(), tempContentResult.getBadlyChanged() + result.getBadlyChanged());
                tempResults.replace(result.getChangerName(), contentResult);
                continue;
            }
            ContentChangerResult contentResult = new ContentChangerResult(result.getChangerName(), result.getAffectedContent(), result.getSuccessfullyChanged(), result.getBadlyChanged());
            tempResults.put(result.getChangerName(), contentResult);
        }
        ArrayList newResults = Lists.newArrayList();
        tempResults.values().forEach(newResults::add);
        return newResults;
    }
}

